/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.ws.validation.AbstractFaultDetailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XmlSoapFaultValidator
extends AbstractFaultDetailValidator
implements InitializingBean,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(XmlSoapFaultValidator.class);
    @Autowired
    private MessageValidatorRegistry messageValidatorRegistry;
    private DomXmlMessageValidator messageValidator;
    private ApplicationContext applicationContext;

    @Override
    protected void validateFaultDetailString(String receivedDetailString, String controlDetailString, TestContext context, ValidationContext validationContext) throws ValidationException {
        XmlMessageValidationContext xmlMessageValidationContext = validationContext instanceof XmlMessageValidationContext ? (XmlMessageValidationContext)validationContext : new XmlMessageValidationContext();
        this.messageValidator.validateMessage((Message)new DefaultMessage((Object)receivedDetailString), (Message)new DefaultMessage((Object)controlDetailString), context, xmlMessageValidationContext);
    }

    public void afterPropertiesSet() throws Exception {
        for (MessageValidator validator : this.messageValidatorRegistry.getMessageValidators()) {
            if (!(validator instanceof DomXmlMessageValidator) || !validator.supportsMessageType(MessageType.XML.name(), (Message)new DefaultMessage((Object)""))) continue;
            this.messageValidator = (DomXmlMessageValidator)validator;
        }
        if (this.messageValidator == null) {
            log.warn("No XML message validator found in Spring bean context - setting default validator");
            this.messageValidator = new DomXmlMessageValidator();
            this.messageValidator.setApplicationContext(this.applicationContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

