/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.interceptor;

import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.util.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class LoggingInterceptorSupport
extends TransformerObjectSupport {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MessageListeners messageListener;

    protected LoggingInterceptorSupport() {
    }

    protected void logRequest(String logMessage, MessageContext messageContext, boolean incoming) throws TransformerException {
        if (messageContext.getRequest() instanceof SoapMessage) {
            this.logSoapMessage(logMessage, (SoapMessage)messageContext.getRequest(), incoming);
        } else {
            this.logWebServiceMessage(logMessage, messageContext.getRequest(), incoming);
        }
    }

    protected void logResponse(String logMessage, MessageContext messageContext, boolean incoming) throws TransformerException {
        if (messageContext.hasResponse()) {
            if (messageContext.getResponse() instanceof SoapMessage) {
                this.logSoapMessage(logMessage, (SoapMessage)messageContext.getResponse(), incoming);
            } else {
                this.logWebServiceMessage(logMessage, messageContext.getResponse(), incoming);
            }
        }
    }

    protected void logSoapMessage(String logMessage, SoapMessage soapMessage, boolean incoming) throws TransformerException {
        Transformer transformer = this.createIndentingTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(soapMessage.getEnvelope().getSource(), new StreamResult(writer));
        this.logMessage(logMessage, XMLUtils.prettyPrint((String)writer.toString()), incoming);
    }

    protected void logWebServiceMessage(String logMessage, WebServiceMessage message, boolean incoming) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)os);
            this.logMessage(logMessage, os.toString(), incoming);
        }
        catch (IOException e) {
            this.log.warn("Unable to log WebService message", (Throwable)e);
        }
    }

    protected void logMessage(String logMessage, String message, boolean incoming) {
        if (this.hasMessageListeners()) {
            this.log.debug(logMessage);
            if (incoming) {
                this.messageListener.onInboundMessage((Message)new RawMessage(message), null);
            } else {
                this.messageListener.onOutboundMessage((Message)new RawMessage(message), null);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(logMessage + ":" + System.getProperty("line.separator") + message);
        }
    }

    public boolean hasMessageListeners() {
        return this.messageListener != null && !this.messageListener.isEmpty();
    }

    private Transformer createIndentingTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.createTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }

    public void setMessageListener(MessageListeners messageListener) {
        this.messageListener = messageListener;
    }
}

