/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message;

import com.consol.citrus.message.Message;
import com.consol.citrus.ws.message.SoapMessage;

public final class SoapMessageUtils {
    private SoapMessageUtils() {
    }

    public static void copy(Message from, SoapMessage to) {
        SoapMessage source = from instanceof SoapMessage ? (SoapMessage)from : new SoapMessage(from);
        SoapMessageUtils.copy(source, to);
    }

    public static void copy(SoapMessage from, SoapMessage to) {
        to.setName(from.getName());
        to.setType(from.getType());
        to.setPayload(from.getPayload());
        if (from.getSoapAction() != null) {
            to.soapAction(from.getSoapAction());
        }
        from.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("citrus_message_id") && !((String)entry.getKey()).equals("citrus_message_timestamp")).forEach(entry -> to.header((String)entry.getKey(), entry.getValue()));
        from.getHeaderData().forEach(to::addHeaderData);
        from.getAttachments().forEach(to::addAttachment);
    }
}

