/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.message.SoapFault;
import com.consol.citrus.ws.validation.SimpleSoapFaultValidator;
import com.consol.citrus.ws.validation.SoapFaultValidationContext;
import com.consol.citrus.ws.validation.SoapFaultValidator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.client.SoapFaultClientException;

public class AssertSoapFault
extends AbstractActionContainer {
    private final TestAction action;
    private final String faultString;
    private final String faultCode;
    private final String faultActor;
    private final List<String> faultDetails;
    private final List<String> faultDetailResourcePaths;
    private final SoapFaultValidator validator;
    private final SoapFaultValidationContext validationContext;
    private static Logger log = LoggerFactory.getLogger(AssertSoapFault.class);

    public AssertSoapFault(Builder builder) {
        super("soap-fault", (AbstractTestContainerBuilder)builder);
        this.action = builder.action.build();
        this.faultString = builder.faultString;
        this.faultCode = builder.faultCode;
        this.faultActor = builder.faultActor;
        this.faultDetails = builder.faultDetails;
        this.faultDetailResourcePaths = builder.faultDetailResourcePaths;
        this.validator = builder.validator;
        this.validationContext = builder.validationContext.build();
    }

    public void doExecute(TestContext context) {
        log.debug("Asserting SOAP fault ...");
        try {
            this.action.execute(context);
        }
        catch (SoapFaultClientException soapFaultException) {
            log.debug("Validating SOAP fault ...");
            SoapFault controlFault = this.constructControlFault(context);
            this.validator.validateSoapFault(SoapFault.from(soapFaultException.getSoapFault()), controlFault, context, this.validationContext);
            log.debug("Asserted SOAP fault as expected: " + soapFaultException.getFaultCode() + ": " + soapFaultException.getFaultStringOrReason());
            log.info("Assert SOAP fault validation successful");
            return;
        }
        catch (Exception e) {
            throw new ValidationException("SOAP fault validation failed for asserted exception type - expected: '" + SoapFaultClientException.class + "' but was: '" + e.getClass().getName() + "'", (Throwable)e);
        }
        throw new ValidationException("SOAP fault validation failed! Missing asserted SOAP fault exception");
    }

    private SoapFault constructControlFault(TestContext context) {
        SoapFault controlFault = new SoapFault();
        if (StringUtils.hasText((String)this.faultActor)) {
            controlFault.faultActor(context.replaceDynamicContentInString(this.faultActor));
        }
        controlFault.faultCode(context.replaceDynamicContentInString(this.faultCode));
        controlFault.faultString(context.replaceDynamicContentInString(this.faultString));
        for (String faultDetail : this.faultDetails) {
            controlFault.addFaultDetail(context.replaceDynamicContentInString(faultDetail));
        }
        try {
            for (String faultDetailPath : this.faultDetailResourcePaths) {
                String resourcePath = context.replaceDynamicContentInString(faultDetailPath);
                controlFault.addFaultDetail(context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)resourcePath, (TestContext)context), (Charset)FileUtils.getCharset((String)resourcePath))));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create SOAP fault detail from file resource", (Throwable)e);
        }
        return controlFault;
    }

    public TestAction getAction() {
        return this.action;
    }

    public TestAction getTestAction(int index) {
        return this.action;
    }

    public List<TestAction> getActions() {
        return Collections.singletonList(this.action);
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public List<String> getFaultDetailResourcePaths() {
        return this.faultDetailResourcePaths;
    }

    public SoapFaultValidator getValidator() {
        return this.validator;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public SoapFaultValidationContext getValidationContext() {
        return this.validationContext;
    }

    public static class Builder
    extends AbstractTestContainerBuilder<AssertSoapFault, Builder>
    implements ReferenceResolverAware {
        private TestActionBuilder<?> action;
        private String faultString;
        private String faultCode;
        private String faultActor;
        private List<String> faultDetails = new ArrayList<String>();
        private List<String> faultDetailResourcePaths = new ArrayList<String>();
        private String validatorName;
        private SoapFaultValidator validator;
        private SoapFaultValidationContext.Builder validationContext;
        private ReferenceResolver referenceResolver;

        public static Builder assertSoapFault() {
            return new Builder();
        }

        public Builder when(TestAction action) {
            return this.when(() -> action);
        }

        public Builder when(TestActionBuilder<?> action) {
            return this.actions((TestActionBuilder<?>[])new TestActionBuilder[]{action});
        }

        public Builder actions(TestActionBuilder<?> ... actions) {
            this.action = actions[0];
            return (Builder)super.actions(new TestActionBuilder[]{actions[0]});
        }

        public Builder faultCode(String code) {
            this.faultCode = code;
            return this;
        }

        public Builder faultString(String faultString) {
            this.faultString = faultString;
            return this;
        }

        public Builder faultActor(String faultActor) {
            this.faultActor = faultActor;
            return this;
        }

        public Builder faultDetail(String faultDetail) {
            this.faultDetails.add(faultDetail);
            return this;
        }

        public Builder faultDetailResource(Resource resource) {
            return this.faultDetailResource(resource, FileUtils.getDefaultCharset());
        }

        public Builder faultDetailResource(Resource resource, Charset charset) {
            try {
                this.faultDetails.add(FileUtils.readToString((Resource)resource, (Charset)charset));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read fault detail resource", (Throwable)e);
            }
            return this;
        }

        public Builder faultDetailResource(String filePath) {
            this.faultDetailResourcePaths.add(filePath);
            return this;
        }

        public Builder validator(SoapFaultValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder validator(String validatorName) {
            this.validatorName = validatorName;
            return this;
        }

        public Builder validate(SoapFaultValidationContext.Builder validationContext) {
            this.validationContext = validationContext;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public AssertSoapFault build() {
            return this.doBuild();
        }

        public AssertSoapFault doBuild() {
            if (this.validationContext == null) {
                this.validationContext = new SoapFaultValidationContext.Builder();
            }
            if (this.referenceResolver != null) {
                if (StringUtils.hasText((String)this.validatorName)) {
                    this.validator((SoapFaultValidator)this.referenceResolver.resolve(this.validatorName, SoapFaultValidator.class));
                }
                if (this.validator == null) {
                    if (this.referenceResolver.isResolvable("soapFaultValidator")) {
                        this.validator((SoapFaultValidator)this.referenceResolver.resolve("soapFaultValidator", SoapFaultValidator.class));
                    } else {
                        this.validator = new SimpleSoapFaultValidator();
                    }
                }
            }
            return new AssertSoapFault(this);
        }
    }
}

