/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.ws.client.WebServiceClient;
import com.consol.citrus.ws.client.WebServiceClientBuilder;
import com.consol.citrus.ws.config.annotation.WebServiceClientConfig;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import java.util.ArrayList;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceClientConfigParser
implements AnnotationConfigParser<WebServiceClientConfig, WebServiceClient> {
    public WebServiceClient parse(WebServiceClientConfig annotation, ReferenceResolver referenceResolver) {
        WebServiceClientBuilder builder = new WebServiceClientBuilder();
        builder.defaultUri(annotation.requestUrl());
        if (StringUtils.hasText((String)annotation.webServiceTemplate()) && (StringUtils.hasText((String)annotation.messageFactory()) || StringUtils.hasText((String)annotation.messageSender()))) {
            throw new CitrusRuntimeException("When providing a 'web-service-template' reference, none of 'message-factory', 'message-sender' should be set");
        }
        if (!StringUtils.hasText((String)annotation.requestUrl()) && !StringUtils.hasText((String)annotation.endpointResolver())) {
            throw new CitrusRuntimeException("One of the properties 'request-url' or 'endpoint-resolver' is required!");
        }
        if (StringUtils.hasText((String)annotation.webServiceTemplate())) {
            builder.webServiceTemplate((WebServiceTemplate)referenceResolver.resolve(annotation.webServiceTemplate(), WebServiceTemplate.class));
        }
        if (StringUtils.hasText((String)annotation.messageFactory())) {
            builder.messageFactory((WebServiceMessageFactory)referenceResolver.resolve(annotation.messageFactory(), WebServiceMessageFactory.class));
        } else {
            builder.messageFactory((WebServiceMessageFactory)referenceResolver.resolve("messageFactory", WebServiceMessageFactory.class));
        }
        if (StringUtils.hasText((String)annotation.messageSender())) {
            builder.messageSender((WebServiceMessageSender)referenceResolver.resolve(annotation.messageSender(), WebServiceMessageSender.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebServiceMessageConverter)referenceResolver.resolve(annotation.messageConverter(), WebServiceMessageConverter.class));
        }
        if (annotation.interceptors().length > 0) {
            builder.interceptors(referenceResolver.resolve(annotation.interceptors(), ClientInterceptor.class));
        }
        if (StringUtils.hasText((String)annotation.interceptor())) {
            ArrayList<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
            interceptors.add((ClientInterceptor)referenceResolver.resolve(annotation.interceptor(), ClientInterceptor.class));
            builder.interceptors(interceptors);
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)referenceResolver.resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.faultStrategy(annotation.faultStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (WebServiceClient)builder.initialize().build();
    }
}

