/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.xml;

import com.consol.citrus.ws.message.SoapAttachment;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class SoapAttachmentParser {
    private SoapAttachmentParser() {
    }

    public static SoapAttachment parseAttachment(Element attachmentElement) {
        Element attachmentResourceElement;
        Element attachmentDataElement;
        SoapAttachment soapAttachment = new SoapAttachment();
        if (attachmentElement.hasAttribute("content-id")) {
            soapAttachment.setContentId(attachmentElement.getAttribute("content-id"));
        }
        if (attachmentElement.hasAttribute("content-type")) {
            soapAttachment.setContentType(attachmentElement.getAttribute("content-type"));
        }
        if (attachmentElement.hasAttribute("charset-name")) {
            soapAttachment.setCharsetName(attachmentElement.getAttribute("charset-name"));
        }
        if (attachmentElement.hasAttribute("mtom-inline")) {
            soapAttachment.setMtomInline(Boolean.parseBoolean(attachmentElement.getAttribute("mtom-inline")));
        }
        if (attachmentElement.hasAttribute("encoding-type")) {
            soapAttachment.setEncodingType(attachmentElement.getAttribute("encoding-type"));
        }
        if ((attachmentDataElement = DomUtils.getChildElementByTagName((Element)attachmentElement, (String)"data")) != null) {
            soapAttachment.setContent(DomUtils.getTextValue((Element)attachmentDataElement));
        }
        if ((attachmentResourceElement = DomUtils.getChildElementByTagName((Element)attachmentElement, (String)"resource")) != null) {
            soapAttachment.setContentResourcePath(attachmentResourceElement.getAttribute("file"));
        }
        return soapAttachment;
    }
}

