/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.StaticMessageBuilder;
import com.consol.citrus.ws.actions.SendSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapFault;
import com.consol.citrus.ws.message.SoapMessage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class SendSoapFaultAction
extends SendSoapMessageAction {
    private final String faultCode;
    private final String faultString;
    private final String faultActor;
    private final List<String> faultDetails;
    private final List<String> faultDetailResourcePaths;

    public SendSoapFaultAction(Builder builder) {
        super(builder);
        this.faultCode = builder.faultCode;
        this.faultString = builder.faultString;
        this.faultActor = builder.faultActor;
        this.faultDetails = builder.faultDetails;
        this.faultDetailResourcePaths = builder.faultDetailResourcePaths;
    }

    @Override
    protected SoapMessage createMessage(TestContext context, String messageType) {
        SoapMessage soapMessage = super.createMessage(context, messageType);
        SoapFault soapFault = new SoapFault();
        soapFault.setPayload(soapMessage.getPayload());
        if (!StringUtils.hasText((String)this.faultCode)) {
            throw new CitrusRuntimeException("Missing fault code definition for SOAP fault generation. Please specify a proper SOAP fault code!");
        }
        soapFault.faultCode(context.replaceDynamicContentInString(this.faultCode));
        for (Map.Entry header : soapMessage.getHeaders().entrySet()) {
            if (((String)header.getKey()).equals("citrus_message_id")) continue;
            soapFault.setHeader((String)header.getKey(), header.getValue());
        }
        for (String headerData : soapMessage.getHeaderData()) {
            soapFault.addHeaderData(headerData);
        }
        for (SoapAttachment soapAttachment : soapMessage.getAttachments()) {
            soapFault.addAttachment(soapAttachment);
        }
        if (StringUtils.hasText((String)this.faultActor)) {
            soapFault.faultActor(context.replaceDynamicContentInString(this.faultActor));
        }
        if (this.faultString != null) {
            soapFault.faultString(context.replaceDynamicContentInString(this.faultString));
        }
        for (String faultDetail : this.faultDetails) {
            soapFault.addFaultDetail(context.replaceDynamicContentInString(faultDetail));
        }
        try {
            for (String faultDetailPath : this.faultDetailResourcePaths) {
                String resourcePath = context.replaceDynamicContentInString(faultDetailPath);
                soapFault.addFaultDetail(context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)resourcePath, (TestContext)context), (Charset)FileUtils.getCharset((String)resourcePath))));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create SOAP fault detail from file resource", (Throwable)e);
        }
        return soapFault;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public List<String> getFaultDetailResourcePaths() {
        return this.faultDetailResourcePaths;
    }

    public static final class Builder
    extends SendSoapMessageAction.SendSoapMessageBuilder<SendSoapFaultAction, SoapFaultMessageBuilderSupport, Builder> {
        private String faultCode;
        private String faultString;
        private String faultActor;
        private final List<String> faultDetails = new ArrayList<String>();
        private final List<String> faultDetailResourcePaths = new ArrayList<String>();

        public Builder() {
            this.message((MessageBuilder)new StaticMessageBuilder((Message)this.soapMessage));
        }

        public SoapFaultMessageBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new SoapFaultMessageBuilderSupport(this.soapMessage, this);
            }
            return (SoapFaultMessageBuilderSupport)super.getMessageBuilderSupport();
        }

        public SendSoapFaultAction doBuild() {
            return new SendSoapFaultAction(this);
        }

        public static class SoapFaultMessageBuilderSupport
        extends SendSoapMessageAction.SoapMessageBuilderSupport<SendSoapFaultAction, Builder, SoapFaultMessageBuilderSupport> {
            protected SoapFaultMessageBuilderSupport(SoapMessage soapMessage, Builder delegate) {
                super(soapMessage, delegate);
            }

            public SoapFaultMessageBuilderSupport faultCode(String code) {
                ((Builder)this.delegate).faultCode = code;
                return this;
            }

            public SoapFaultMessageBuilderSupport faultString(String faultString) {
                ((Builder)this.delegate).faultString = faultString;
                return this;
            }

            public SoapFaultMessageBuilderSupport faultActor(String faultActor) {
                ((Builder)this.delegate).faultActor = faultActor;
                return this;
            }

            public SoapFaultMessageBuilderSupport faultDetail(String faultDetail) {
                ((Builder)this.delegate).faultDetails.add(faultDetail);
                return this;
            }

            public SoapFaultMessageBuilderSupport faultDetailResource(Resource resource) {
                return this.faultDetailResource(resource, FileUtils.getDefaultCharset());
            }

            public SoapFaultMessageBuilderSupport faultDetailResource(Resource resource, Charset charset) {
                try {
                    ((Builder)this.delegate).faultDetails.add(FileUtils.readToString((Resource)resource, (Charset)charset));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read fault detail resource", (Throwable)e);
                }
                return this;
            }

            public SoapFaultMessageBuilderSupport faultDetailResource(String filePath) {
                ((Builder)this.delegate).faultDetailResourcePaths.add(filePath);
                return this;
            }

            public SoapFaultMessageBuilderSupport status(HttpStatus status) {
                this.soapMessage.header("citrus_http_status_code", status.value());
                return this;
            }

            public SoapFaultMessageBuilderSupport statusCode(Integer statusCode) {
                this.soapMessage.header("citrus_http_status_code", statusCode);
                return this;
            }
        }
    }
}

