/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.xml;

import com.consol.citrus.TestAction;
import com.consol.citrus.config.CitrusNamespaceParserRegistry;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractTestActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.ws.actions.AssertSoapFault;
import com.consol.citrus.ws.validation.SoapFaultDetailValidationContext;
import com.consol.citrus.ws.validation.SoapFaultValidationContext;
import com.consol.citrus.ws.validation.SoapFaultValidator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.DOMUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssertSoapFaultParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element action;
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(AssertSoapFaultActionFactoryBean.class);
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("fault-code"), (String)"faultCode");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("fault-string"), (String)"faultString");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("fault-actor"), (String)"faultActor");
        List faultDetails = DomUtils.getChildElementsByTagName((Element)element, (String)"fault-detail");
        SoapFaultValidationContext.Builder validationContext = new SoapFaultValidationContext.Builder();
        ArrayList<String> soapFaultDetails = new ArrayList<String>();
        ArrayList<CallSite> soapFaultDetailPaths = new ArrayList<CallSite>();
        for (Element faultDetailElement : faultDetails) {
            String schemaRepository;
            String schema;
            if (faultDetailElement.hasAttribute("file")) {
                if (StringUtils.hasText((String)DomUtils.getTextValue((Element)faultDetailElement).trim())) {
                    throw new BeanCreationException("You tried to set fault-detail by file resource attribute and inline text value at the same time! Please choose one of them.");
                }
                String charset = faultDetailElement.getAttribute("charset");
                String filePath = faultDetailElement.getAttribute("file");
                soapFaultDetailPaths.add((CallSite)((Object)(filePath + (String)(StringUtils.hasText((String)charset) ? ";charset=" + charset : ""))));
            } else {
                String faultDetailData = DomUtils.getTextValue((Element)faultDetailElement).trim();
                if (StringUtils.hasText((String)faultDetailData)) {
                    soapFaultDetails.add(faultDetailData);
                } else {
                    throw new BeanCreationException("Not content for fault-detail is set! Either use file attribute or inline text value for fault-detail element.");
                }
            }
            SoapFaultDetailValidationContext.Builder context = new SoapFaultDetailValidationContext.Builder();
            String schemaValidation = faultDetailElement.getAttribute("schema-validation");
            if (StringUtils.hasText((String)schemaValidation)) {
                context.schemaValidation(Boolean.parseBoolean(schemaValidation));
            }
            if (StringUtils.hasText((String)(schema = faultDetailElement.getAttribute("schema")))) {
                context.schema(schema);
            }
            if (StringUtils.hasText((String)(schemaRepository = faultDetailElement.getAttribute("schema-repository")))) {
                context.schemaRepository(schemaRepository);
            }
            validationContext.detail(context.build());
        }
        if (!soapFaultDetails.isEmpty() || !soapFaultDetailPaths.isEmpty()) {
            beanDefinition.addPropertyValue("faultDetails", soapFaultDetails);
            beanDefinition.addPropertyValue("faultDetailResourcePaths", soapFaultDetailPaths);
            beanDefinition.addPropertyValue("validationContext", (Object)validationContext);
        }
        if ((action = DOMUtil.getFirstChildElement((Node)DomUtils.getChildElementByTagName((Element)element, (String)"when"))) != null) {
            BeanDefinitionParser parser = null;
            if (action.getNamespaceURI().equals("http://www.citrusframework.org/schema/testcase")) {
                parser = CitrusNamespaceParserRegistry.getBeanParser((String)action.getLocalName());
            }
            if (parser == null) {
                beanDefinition.addPropertyValue("action", (Object)parserContext.getReaderContext().getNamespaceHandlerResolver().resolve(action.getNamespaceURI()).parse(action, parserContext));
            } else {
                beanDefinition.addPropertyValue("action", (Object)parser.parse(action, parserContext));
            }
        }
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)beanDefinition, (String)element.getAttribute("fault-validator"), (String)"validator", (String)"soapFaultValidator");
        return beanDefinition.getBeanDefinition();
    }

    public static class AssertSoapFaultActionFactoryBean
    extends AbstractTestActionFactoryBean<AssertSoapFault, AssertSoapFault.Builder> {
        private final AssertSoapFault.Builder builder = new AssertSoapFault.Builder();

        public void setAction(TestAction action) {
            this.builder.when(action);
        }

        public void setFaultCode(String faultCode) {
            this.builder.faultCode(faultCode);
        }

        public void setFaultString(String faultString) {
            this.builder.faultString(faultString);
        }

        public void setValidator(SoapFaultValidator validator) {
            this.builder.validator(validator);
        }

        public void setFaultDetails(List<String> faultDetails) {
            faultDetails.forEach(this.builder::faultDetail);
        }

        public void setFaultDetailResourcePaths(List<String> faultDetailResourcePaths) {
            faultDetailResourcePaths.forEach(this.builder::faultDetailResource);
        }

        public void setFaultActor(String faultActor) {
            this.builder.faultActor(faultActor);
        }

        public void setValidationContext(SoapFaultValidationContext.Builder validationContext) {
            this.builder.validate(validationContext);
        }

        public AssertSoapFault getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return AssertSoapFault.class;
        }

        public AssertSoapFault.Builder getBuilder() {
            return this.builder;
        }
    }
}

