/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.ws.actions.ReceiveSoapMessageAction;
import com.consol.citrus.ws.actions.SendSoapMessageAction;
import org.springframework.util.Assert;

public class SoapClientActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private Endpoint soapClient;
    private String soapClientUri;
    private TestActionBuilder<?> delegate;

    public SoapClientActionBuilder(Endpoint soapClient) {
        this.soapClient = soapClient;
    }

    public SoapClientActionBuilder(String soapClientUri) {
        this.soapClientUri = soapClientUri;
    }

    public ReceiveSoapMessageAction.Builder receive() {
        ReceiveSoapMessageAction.Builder builder = new ReceiveSoapMessageAction.Builder();
        if (this.soapClient != null) {
            builder.endpoint(this.soapClient);
        } else {
            builder.endpoint(this.soapClientUri);
        }
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SendSoapMessageAction.Builder send() {
        SendSoapMessageAction.Builder builder = new SendSoapMessageAction.Builder();
        if (this.soapClient != null) {
            builder.endpoint(this.soapClient);
        } else {
            builder.endpoint(this.soapClientUri);
        }
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public SoapClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

