/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.addressing;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ws.addressing.WsAddressingVersion;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.ws.soap.addressing.core.EndpointReference;

public class WsAddressingHeaders {
    private WsAddressingVersion version;
    private URI action;
    private URI to;
    private URI messageId;
    private EndpointReference from;
    private EndpointReference replyTo;
    private EndpointReference faultTo;

    public WsAddressingVersion getVersion() {
        return this.version;
    }

    public void setVersion(WsAddressingVersion version) {
        this.version = version;
    }

    public URI getAction() {
        return this.action;
    }

    public void setAction(URI action) {
        this.action = action;
    }

    public void setAction(String action) {
        try {
            this.action = new URI(action);
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid action uri", (Throwable)e);
        }
    }

    public URI getTo() {
        return this.to;
    }

    public void setTo(URI to) {
        this.to = to;
    }

    public void setTo(String to) {
        try {
            this.to = new URI(to);
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid to uri", (Throwable)e);
        }
    }

    public URI getMessageId() {
        return this.messageId;
    }

    public void setMessageId(URI messageId) {
        this.messageId = messageId;
    }

    public void setMessageId(String messageId) {
        try {
            this.messageId = new URI(messageId);
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid messageId uri", (Throwable)e);
        }
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public void setFrom(String from) {
        try {
            this.from = new EndpointReference(new URI(from));
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid from uri", (Throwable)e);
        }
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    public void setReplyTo(String replyTo) {
        try {
            this.replyTo = new EndpointReference(new URI(replyTo));
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid replyTo uri", (Throwable)e);
        }
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    public void setFaultTo(String faultTo) {
        try {
            this.faultTo = new EndpointReference(new URI(faultTo));
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException("Invalid faultTo uri", (Throwable)e);
        }
    }
}

