/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.context.TestContextFactoryBean;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.ws.validation.SimpleSoapAttachmentValidator;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSoapAttachmentValidator
extends SimpleSoapAttachmentValidator
implements ReferenceResolverAware {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSoapAttachmentValidator.class);
    private TestContextFactory testContextFactory;
    private MessageValidator<? extends ValidationContext> messageValidator;
    private ReferenceResolver referenceResolver;
    public static final String DEFAULT_XML_MESSAGE_VALIDATOR = "defaultXmlMessageValidator";

    @Override
    protected void validateAttachmentContentData(String receivedContent, String controlContent, String controlContentId) {
        this.getMessageValidator().validateMessage((Message)new DefaultMessage((Object)receivedContent), (Message)new DefaultMessage((Object)controlContent), this.getTestContextFactory().getObject(), Collections.singletonList(new XmlMessageValidationContext()));
    }

    private TestContextFactory getTestContextFactory() {
        if (this.testContextFactory == null) {
            this.testContextFactory = this.referenceResolver != null && this.referenceResolver.isResolvable(TestContextFactoryBean.class) ? (TestContextFactory)this.referenceResolver.resolve(TestContextFactoryBean.class) : TestContextFactory.newInstance();
        }
        return this.testContextFactory;
    }

    private MessageValidator<? extends ValidationContext> getMessageValidator() {
        if (this.messageValidator != null) {
            return this.messageValidator;
        }
        Optional<MessageValidator> defaultMessageValidator = this.getTestContextFactory().getMessageValidatorRegistry().findMessageValidator(DEFAULT_XML_MESSAGE_VALIDATOR);
        if (defaultMessageValidator.isEmpty()) {
            try {
                defaultMessageValidator = Optional.of((MessageValidator)this.getTestContextFactory().getReferenceResolver().resolve(DEFAULT_XML_MESSAGE_VALIDATOR, MessageValidator.class));
            }
            catch (CitrusRuntimeException e) {
                LOG.warn("Unable to find default XML message validator in message validator registry");
            }
        }
        if (defaultMessageValidator.isEmpty()) {
            defaultMessageValidator = MessageValidator.lookup((String)"xml");
        }
        if (defaultMessageValidator.isPresent()) {
            this.messageValidator = (MessageValidator)defaultMessageValidator.get();
            return this.messageValidator;
        }
        throw new CitrusRuntimeException("Unable to locate proper XML message validator - please add validator to project");
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

