/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message.converter;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.ws.addressing.WsAddressingHeaders;
import com.consol.citrus.ws.addressing.WsAddressingVersion;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import com.consol.citrus.ws.message.converter.SoapMessageConverter;
import java.net.URI;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.UuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.version.Addressing10;
import org.springframework.ws.soap.addressing.version.Addressing200408;

public class WsAddressingMessageConverter
extends SoapMessageConverter {
    private final WsAddressingHeaders addressingHeaders;
    private MessageIdStrategy messageIdStrategy = new UuidMessageIdStrategy();

    public WsAddressingMessageConverter(WsAddressingHeaders addressingHeaders) {
        this.addressingHeaders = addressingHeaders;
    }

    @Override
    public void convertOutbound(WebServiceMessage webServiceMessage, Message message, WebServiceEndpointConfiguration endpointConfiguration, TestContext context) {
        Addressing10 version;
        super.convertOutbound(webServiceMessage, message, endpointConfiguration, context);
        SoapMessage soapMessage = (SoapMessage)webServiceMessage;
        URI messageId = message.getHeader("citrus_soap_ws_addressing_messageId") != null ? URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_messageId").toString())) : (this.addressingHeaders.getMessageId() != null ? this.addressingHeaders.getMessageId() : this.messageIdStrategy.newMessageId(soapMessage));
        EndpointReference from = this.addressingHeaders.getFrom();
        if (message.getHeader("citrus_soap_ws_addressing_from") != null) {
            from = new EndpointReference(URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_from").toString())));
        }
        URI to = this.addressingHeaders.getTo();
        if (message.getHeader("citrus_soap_ws_addressing_to") != null) {
            to = URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_to").toString()));
        }
        URI action = this.addressingHeaders.getAction();
        if (message.getHeader("citrus_soap_ws_addressing_action") != null) {
            action = URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_action").toString()));
        }
        EndpointReference replyTo = this.addressingHeaders.getReplyTo();
        if (message.getHeader("citrus_soap_ws_addressing_replyTo") != null) {
            replyTo = new EndpointReference(URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_replyTo").toString())));
        }
        EndpointReference faultTo = this.addressingHeaders.getReplyTo();
        if (message.getHeader("citrus_soap_ws_addressing_faultTo") != null) {
            faultTo = new EndpointReference(URI.create(context.replaceDynamicContentInString(message.getHeader("citrus_soap_ws_addressing_faultTo").toString())));
        }
        MessageAddressingProperties map = new MessageAddressingProperties(to, from, replyTo, faultTo, action, messageId);
        if (WsAddressingVersion.VERSION10.equals((Object)this.addressingHeaders.getVersion())) {
            version = new Addressing10();
        } else if (WsAddressingVersion.VERSION200408.equals((Object)this.addressingHeaders.getVersion())) {
            version = new Addressing200408();
        } else {
            throw new CitrusRuntimeException("Unsupported ws addressing version '" + this.addressingHeaders.getVersion() + "'");
        }
        version.addAddressingHeaders(soapMessage, map);
    }

    public MessageIdStrategy getMessageIdStrategy() {
        return this.messageIdStrategy;
    }

    public void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        this.messageIdStrategy = messageIdStrategy;
    }

    public WsAddressingHeaders getAddressingHeaders() {
        return this.addressingHeaders;
    }
}

