/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.xml.StringSource;
import com.consol.citrus.xml.container.Template;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;

public class TemplateLoader
implements ReferenceResolverAware {
    private final JAXBContext jaxbContext;
    private final String source;
    private Template template;
    private ReferenceResolver referenceResolver;
    private static final Pattern NAMESPACE_IS_SET = Pattern.compile("^\\s*<(\\w+:)?template .*xmlns(:\\w+)?=\\s*\".*>\\s*$", 32);

    public TemplateLoader(String source) {
        this.source = source;
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"com.consol.citrus.xml");
        }
        catch (JAXBException e) {
            throw new CitrusRuntimeException("Failed to create TemplateLoader instance", (Throwable)e);
        }
    }

    public Template load() {
        if (this.template == null) {
            Resource xmlSource = FileUtils.getFileResource((String)this.source);
            try {
                this.template = (Template)this.jaxbContext.createUnmarshaller().unmarshal((Source)new StringSource(TemplateLoader.applyNamespace(FileUtils.readToString((Resource)xmlSource))), Template.class).getValue();
            }
            catch (IOException | JAXBException e) {
                throw new CitrusRuntimeException("Failed to load XML template for source '" + this.source + "'", e);
            }
            this.template.setReferenceResolver(this.referenceResolver);
        }
        return this.template;
    }

    public static String applyNamespace(String xmlSource) {
        if (NAMESPACE_IS_SET.matcher(xmlSource).matches()) {
            return xmlSource;
        }
        return xmlSource.replace("<template ", String.format("<template xmlns=\"%s\" ", "http://citrusframework.org/schema/xml/testcase"));
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public TemplateLoader withReferenceResolver(ReferenceResolver referenceResolver) {
        this.setReferenceResolver(referenceResolver);
        return this;
    }
}

