/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.variable.VariableUtils;
import com.consol.citrus.xml.TestActions;
import com.consol.citrus.xml.actions.script.ScriptDefinitionType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.core.io.Resource;

@XmlRootElement(name="test")
public class XmlTestCase {
    private final DefaultTestCase delegate = new DefaultTestCase();

    public TestCase getTestCase() {
        return this.delegate;
    }

    @XmlAttribute
    public void setName(String name) {
        this.delegate.setName(name);
    }

    @XmlAttribute
    public void setAuthor(String author) {
        this.delegate.getMetaInfo().setAuthor(author);
    }

    @XmlAttribute
    public void setStatus(TestCaseMetaInfo.Status status) {
        this.delegate.getMetaInfo().setStatus(status);
    }

    @XmlElement
    public void setVariables(Variables variables) {
        variables.getVariables().forEach(variable -> {
            if (variable.multilineValue != null) {
                if (variable.multilineValue.script != null) {
                    if (variable.multilineValue.script.getFile() != null) {
                        try {
                            this.delegate.getVariableDefinitions().put(variable.name, VariableUtils.getValueFromScript((String)variable.multilineValue.script.getType(), (String)FileUtils.readToString((Resource)FileUtils.getFileResource((String)variable.multilineValue.script.getFile()), (Charset)Optional.ofNullable(variable.multilineValue.script.getCharset()).map(Charset::forName).orElse(FileUtils.getDefaultCharset()))));
                        }
                        catch (IOException e) {
                            throw new CitrusRuntimeException("Failed to read script file resource", (Throwable)e);
                        }
                    } else {
                        this.delegate.getVariableDefinitions().put(variable.name, VariableUtils.getValueFromScript((String)variable.multilineValue.script.getType(), (String)variable.multilineValue.script.getValue()));
                    }
                } else {
                    this.delegate.getVariableDefinitions().put(variable.name, variable.multilineValue.data);
                }
            } else {
                this.delegate.getVariableDefinitions().put(variable.name, variable.value);
            }
        });
    }

    @XmlElement
    public void setActions(TestActions actions) {
        actions.getActionBuilders().forEach(arg_0 -> ((DefaultTestCase)this.delegate).addTestAction(arg_0));
    }

    @XmlElement
    public void setFinally(TestActions actions) {
        actions.getActionBuilders().forEach(arg_0 -> ((DefaultTestCase)this.delegate).addFinalAction(arg_0));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"variables"})
    public static class Variables {
        @XmlElement(name="variable", required=true)
        protected List<Variable> variables;

        public List<Variable> getVariables() {
            if (this.variables == null) {
                this.variables = new ArrayList<Variable>();
            }
            return this.variables;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"multilineValue"})
        public static class Variable {
            @XmlElement(name="value")
            protected Value multilineValue;
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public Value getMultilineValue() {
                return this.multilineValue;
            }

            public void setMultilineValue(Value value) {
                this.multilineValue = value;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"script", "data"})
            public static class Value {
                protected ScriptDefinitionType script;
                protected String data;

                public ScriptDefinitionType getScript() {
                    return this.script;
                }

                public void setScript(ScriptDefinitionType value) {
                    this.script = value;
                }

                public String getData() {
                    return this.data;
                }

                public void setData(String value) {
                    this.data = value;
                }
            }
        }
    }
}

