/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml;

import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.xml.StringSource;
import com.consol.citrus.xml.XmlTestCase;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class XmlTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private String source;
    private final JAXBContext jaxbContext;
    public static final String TEST_NS = "http://citrusframework.org/schema/xml/testcase";
    private static final Pattern NAMESPACE_IS_SET = Pattern.compile(".*<(\\w+:)?test .*xmlns(:\\w+)?=\\s*\".*>.*", 32);

    public XmlTestLoader() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"com.consol.citrus.xml");
        }
        catch (JAXBException e) {
            throw new CitrusRuntimeException("Failed to create XMLTestLoader instance", (Throwable)e);
        }
    }

    public XmlTestLoader(Class<?> testClass, String testName, String packageName) {
        this();
        this.testClass = testClass;
        this.testName = testName;
        this.packageName = packageName;
    }

    public void doLoad() {
        Resource xmlSource = FileUtils.getFileResource((String)this.getSource());
        try {
            this.testCase = ((XmlTestCase)this.jaxbContext.createUnmarshaller().unmarshal((Source)new StringSource(XmlTestLoader.applyNamespace(FileUtils.readToString((Resource)xmlSource))), XmlTestCase.class).getValue()).getTestCase();
            if (this.runner instanceof DefaultTestCaseRunner) {
                ((DefaultTestCaseRunner)this.runner).setTestCase(this.testCase);
            }
            this.testCase.getActionBuilders().stream().filter(action -> ReferenceResolverAware.class.isAssignableFrom(action.getClass())).map(ReferenceResolverAware.class::cast).forEach(action -> action.setReferenceResolver(this.context.getReferenceResolver()));
            this.configurer.forEach(handler -> handler.accept(this.testCase));
            this.citrus.run((TestAction)this.testCase, this.context);
            this.handler.forEach(handler -> handler.accept(this.testCase));
        }
        catch (IOException | JAXBException e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load XML test with name '" + this.testName + "'", (Exception)e);
        }
    }

    public static String applyNamespace(String xmlSource) {
        if (NAMESPACE_IS_SET.matcher(xmlSource).matches()) {
            return xmlSource;
        }
        return xmlSource.replace("<test ", String.format("<test xmlns=\"%s\" ", TEST_NS));
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        return "classpath:" + this.packageName.replace('.', File.separatorChar) + File.separator + this.testName + ".xml";
    }

    public void setSource(String source) {
        this.source = source;
    }

    public XmlTestLoader source(String source) {
        this.setSource(source);
        return this;
    }
}

