/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.Template;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.spi.SimpleReferenceResolver;
import com.consol.citrus.xml.TemplateLoader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="apply-template")
public class ApplyTemplate
implements TestActionBuilder<Template>,
ReferenceResolverAware {
    private final Template.Builder builder = new Template.Builder();
    private String filePath;
    private ReferenceResolver referenceResolver;

    @XmlAttribute
    public ApplyTemplate setName(String name) {
        this.builder.templateName(name);
        return this;
    }

    @XmlAttribute
    public ApplyTemplate setFile(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @XmlElement
    public ApplyTemplate setParameters(Parameters parameters) {
        parameters.getParameters().forEach(p -> {
            if (p.multilineValue != null) {
                this.builder.parameter(p.name, p.multilineValue);
            } else if (p.value != null) {
                this.builder.parameter(p.name, p.value);
            }
        });
        return this;
    }

    public Template build() {
        if (this.filePath != null) {
            Template local = new TemplateLoader(this.filePath).withReferenceResolver(this.referenceResolver).load().build();
            SimpleReferenceResolver temporaryReferenceResolver = new SimpleReferenceResolver();
            temporaryReferenceResolver.bind(local.getTemplateName(), (Object)local);
            this.builder.withReferenceResolver((ReferenceResolver)temporaryReferenceResolver);
            this.builder.templateName(local.getTemplateName());
        } else {
            this.builder.withReferenceResolver(this.referenceResolver);
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"parameters"})
    public static class Parameters {
        @XmlElement(name="parameter")
        protected List<Parameter> parameters;

        public List<Parameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            return this.parameters;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Parameter {
            @XmlElement(name="value")
            protected String multilineValue;
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute
            protected String value = "";

            public String getMultilineValue() {
                return this.multilineValue;
            }

            public void setMultilineValue(String value) {
                this.multilineValue = value;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

