/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.CreateVariablesAction;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.springframework.core.io.Resource;

@XmlRootElement(name="create-variables")
public class CreateVariables
implements TestActionBuilder<CreateVariablesAction> {
    private final CreateVariablesAction.Builder builder = new CreateVariablesAction.Builder();
    @XmlElement(name="variable", required=true)
    protected List<Variable> variables = new ArrayList<Variable>();

    public CreateVariablesAction build() {
        for (Variable variable : this.variables) {
            if (variable.getVariableValue() != null) {
                if (variable.getVariableValue().getScript() != null) {
                    if (variable.getVariableValue().getScript().getFile() != null) {
                        try {
                            this.builder.variable(variable.getName(), FileUtils.readToString((Resource)FileUtils.getFileResource((String)variable.getVariableValue().getScript().getFile())));
                            continue;
                        }
                        catch (IOException e) {
                            throw new CitrusRuntimeException("Failed to read variable script file resource", (Throwable)e);
                        }
                    }
                    this.builder.variable(variable.getName(), String.format("script:<%s>%s", Optional.ofNullable(variable.getVariableValue().getScript().getType()).orElse("groovy"), variable.getVariableValue().getScript().getValue()));
                    continue;
                }
                this.builder.variable(variable.getName(), variable.getVariableValue().getData());
                continue;
            }
            this.builder.variable(variable.getName(), variable.getValue());
        }
        return this.builder.build();
    }

    @XmlElement
    public CreateVariables setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    public CreateVariables setVariables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Variable {
        @XmlElement(name="value")
        protected Value variableValue;
        @XmlAttribute(name="name", required=true)
        protected String name;
        @XmlAttribute(name="value")
        protected String value;

        public Value getVariableValue() {
            return this.variableValue;
        }

        public void setVariableValue(Value value) {
            this.variableValue = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="ScriptType", propOrder={"value"})
        public static class Script {
            @XmlValue
            protected String value;
            @XmlAttribute(name="type", required=true)
            protected String type;
            @XmlAttribute(name="file")
            protected String file;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String value) {
                this.type = value;
            }

            public String getFile() {
                return this.file;
            }

            public void setFile(String value) {
                this.file = value;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"script", "data"})
        public static class Value {
            protected Script script;
            protected String data;

            public Script getScript() {
                return this.script;
            }

            public void setScript(Script value) {
                this.script = value;
            }

            public String getData() {
                return this.data;
            }

            public void setData(String value) {
                this.data = value;
            }
        }
    }
}

