/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.actions;

import com.consol.citrus.dsl.MessageSupport;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DelegatingPathExpressionProcessor;
import com.consol.citrus.message.MessageHeaderType;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.ScriptPayloadBuilder;
import com.consol.citrus.message.builder.MessageBuilderSupport;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.interceptor.BinaryMessageProcessor;
import com.consol.citrus.validation.interceptor.GzipMessageProcessor;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.xml.actions.Message;
import com.consol.citrus.xml.util.PayloadElementParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.springframework.util.StringUtils;

public final class MessageSupport {
    private MessageSupport() {
    }

    public static void configureMessage(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message message) {
        Message.Headers headers;
        if (message.type != null) {
            if (StringUtils.hasText((String)message.type)) {
                if (message.type.equalsIgnoreCase(MessageType.GZIP.name())) {
                    builder.process((MessageProcessor)new GzipMessageProcessor());
                }
                if (message.type.equalsIgnoreCase(MessageType.BINARY.name())) {
                    builder.process((MessageProcessor)new BinaryMessageProcessor());
                }
            }
            builder.message().type(message.type);
        }
        if (message.body != null) {
            if (message.body.data != null) {
                builder.message().body(message.body.data.trim());
            }
            if (message.body.resource != null) {
                if (message.body.resource.charset != null) {
                    builder.message().body(FileUtils.getFileResource((String)(message.body.resource.file + ";charset=" + message.body.resource.charset)));
                } else {
                    builder.message().body(FileUtils.getFileResource((String)message.body.resource.file));
                }
            }
            if (message.body.payload != null && !message.body.payload.getAnies().isEmpty()) {
                builder.message().body(PayloadElementParser.parseMessagePayload(message.body.payload.anies.get(0)));
            }
        }
        MessageSupport.configureScriptPayloadBuilder(builder, message);
        if (message.name != null) {
            builder.message().name(message.name);
        }
        HashMap<String, String> pathExpressions = new HashMap<String, String>();
        for (Message.Expression expression : message.getExpressions()) {
            String pathExpression = expression.path;
            pathExpressions.put(pathExpression, expression.value);
        }
        if (!pathExpressions.isEmpty()) {
            builder.message().process((MessageProcessor)new DelegatingPathExpressionProcessor(pathExpressions));
        }
        if (message.dataDictionary != null) {
            builder.message().dictionary(message.dataDictionary);
        }
        if ((headers = message.getHeaders()) != null) {
            for (Message.Headers.Header header : headers.getHeaders()) {
                if (header.value != null) {
                    String headerValue = StringUtils.hasText((String)header.type) ? MessageHeaderType.createTypedValue((String)header.type, (String)header.value) : header.value;
                    builder.message().header(header.name, (Object)headerValue);
                }
                if (header.data != null) {
                    if (header.name != null) {
                        builder.message().header(header.name, (Object)header.data);
                    } else {
                        builder.message().header(header.data);
                    }
                }
                if (header.fragment != null && !header.fragment.getAnies().isEmpty()) {
                    if (header.name != null) {
                        builder.message().header(header.name, (Object)PayloadElementParser.parseMessagePayload(header.fragment.anies.get(0)));
                    } else {
                        builder.message().header(PayloadElementParser.parseMessagePayload(header.fragment.anies.get(0)));
                    }
                }
                if (header.resource == null) continue;
                if (header.resource.charset != null) {
                    builder.message().header(FileUtils.getFileResource((String)(header.resource.file + ";charset=" + header.resource.charset)));
                    continue;
                }
                builder.message().header(FileUtils.getFileResource((String)header.resource.file));
            }
        }
    }

    private static void configureScriptPayloadBuilder(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message message) {
        if (message.body != null && message.body.builder != null) {
            String scriptType = Optional.ofNullable(message.body.builder.getType()).orElse("groovy");
            Optional scriptPayloadBuilder = ScriptPayloadBuilder.lookup((String)scriptType);
            if (scriptPayloadBuilder.isPresent()) {
                if (message.body.builder.getValue() != null) {
                    ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setScript(message.body.builder.getValue().trim());
                }
                if (message.body.builder.getFile() != null) {
                    if (message.body.builder.getCharset() != null) {
                        ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setFile(FileUtils.getFileResource((String)(message.body.builder.getFile() + ";charset=" + message.body.builder.getCharset())));
                    } else {
                        ((ScriptPayloadBuilder)scriptPayloadBuilder.get()).setFile(FileUtils.getFileResource((String)message.body.builder.getFile()));
                    }
                }
                builder.message().body((MessagePayloadBuilder)scriptPayloadBuilder.get());
            } else {
                throw new CitrusRuntimeException(String.format("Failed to resolve script payload builder for type '%s'", scriptType));
            }
        }
    }

    public static void configureExtract(MessageBuilderSupport.MessageActionBuilder<?, ?, ?> builder, Message.Extract value) {
        LinkedHashMap<String, String> expressions;
        if (!value.getHeaders().isEmpty()) {
            expressions = new LinkedHashMap<String, String>();
            for (Message.Extract.Header header : value.getHeaders()) {
                expressions.put(header.name, header.variable);
            }
            builder.message().extract((VariableExtractor.Builder)MessageSupport.MessageHeaderSupport.fromHeaders().expressions(expressions));
        }
        if (!value.getBodyExpressions().isEmpty()) {
            expressions = new LinkedHashMap();
            for (Message.Extract.Expression expression : value.getBodyExpressions()) {
                Object pathExpression = expression.path;
                if (expression.resultType != null) {
                    pathExpression = expression.resultType + ":" + (String)pathExpression;
                }
                expressions.put((String)pathExpression, expression.variable);
            }
            builder.message().extract((VariableExtractor.Builder)MessageSupport.MessageBodySupport.fromBody().expressions(expressions));
        }
    }
}

