/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActor;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.xml.actions.Message;
import com.consol.citrus.xml.actions.MessageSupport;
import com.consol.citrus.xml.actions.script.ScriptDefinitionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.util.StringUtils;

@XmlRootElement(name="receive")
public class Receive
implements TestActionBuilder<ReceiveMessageAction>,
ReferenceResolverAware {
    private final ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?> builder;
    private String actor;
    private ReferenceResolver referenceResolver;
    private final List<String> validators = new ArrayList<String>();
    private final XmlMessageValidationContext.Builder xmlValidationContext = new XmlMessageValidationContext.Builder();
    private final JsonMessageValidationContext.Builder jsonValidationContext = new JsonMessageValidationContext.Builder();
    @XmlElement(name="ignore")
    protected List<Ignore> ignores;
    @XmlElement(name="validate")
    protected List<Validate> validates;
    @XmlElement(name="namespace")
    protected List<Namespace> namespaces;

    public Receive() {
        this((ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?>)new ReceiveMessageAction.Builder());
    }

    public Receive(ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?, ?> builder) {
        this.builder = builder;
    }

    @XmlElement
    public Receive setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    public List<Ignore> getIgnores() {
        if (this.ignores == null) {
            this.ignores = new ArrayList<Ignore>();
        }
        return this.ignores;
    }

    public List<Validate> getValidates() {
        if (this.validates == null) {
            this.validates = new ArrayList<Validate>();
        }
        return this.validates;
    }

    public List<Namespace> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<Namespace>();
        }
        return this.namespaces;
    }

    @XmlAttribute(name="validator")
    public Receive setValidator(String validator) {
        if (StringUtils.hasText((String)validator)) {
            this.validators.add(validator);
        }
        return this;
    }

    @XmlAttribute(name="validators")
    public Receive setValidators(String messageValidatorExpression) {
        if (StringUtils.hasText((String)messageValidatorExpression)) {
            Stream.of(messageValidatorExpression.split(",")).map(String::trim).forEach(this.validators::add);
        }
        return this;
    }

    @XmlAttribute(name="header-validator")
    public Receive setHeaderValidator(String headerValidator) {
        if (StringUtils.hasText((String)headerValidator)) {
            this.builder.getHeaderValidationContext().addHeaderValidator(headerValidator);
        }
        return this;
    }

    @XmlAttribute(name="header-validators")
    public Receive setHeaderValidators(String headerValidatorExpression) {
        if (StringUtils.hasText((String)headerValidatorExpression)) {
            Stream.of(headerValidatorExpression.split(",")).map(String::trim).forEach(arg_0 -> ((HeaderValidationContext)this.builder.getHeaderValidationContext()).addHeaderValidator(arg_0));
        }
        return this;
    }

    @XmlElement(required=true)
    public Receive setMessage(Message message) {
        MessageSupport.configureMessage(this.builder, message);
        if (message.schema != null || message.schemaRepository != null) {
            ((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)this.xmlValidationContext.schemaValidation(message.isSchemaValidation().booleanValue())).schema(message.schema)).schemaRepository(message.schemaRepository);
            this.jsonValidationContext.schemaValidation(message.isSchemaValidation().booleanValue()).schema(message.schema).schemaRepository(message.schemaRepository);
        } else if (message.isSchemaValidation() != null && !message.isSchemaValidation().booleanValue()) {
            this.xmlValidationContext.schemaValidation(message.isSchemaValidation().booleanValue());
            this.jsonValidationContext.schemaValidation(message.isSchemaValidation().booleanValue());
        }
        return this;
    }

    private void addScriptValidationContext() {
        ScriptValidationContext.Builder context = null;
        for (Validate validateElement : this.getValidates()) {
            ScriptDefinitionType scriptElement = validateElement.getScript();
            if (scriptElement == null) continue;
            if (context != null) {
                throw new CitrusRuntimeException("Found multiple validation script definitions - only supporting a single validation script for message validation");
            }
            String type = scriptElement.getType();
            context = new ScriptValidationContext.Builder().scriptType(type);
            String filePath = scriptElement.getFile();
            if (StringUtils.hasText((String)filePath)) {
                context.scriptResource(filePath);
                if (scriptElement.getCharset() != null) {
                    context.scriptResourceCharset(scriptElement.getCharset());
                }
            } else if (scriptElement.getValue() != null) {
                context.script(scriptElement.getValue().trim());
            }
            this.builder.validate((ValidationContext.Builder)context);
        }
    }

    private void addJsonValidationContext() {
        HashSet<String> ignoreExpressions = new HashSet<String>();
        for (Ignore ignoreValue : this.getIgnores()) {
            ignoreExpressions.add(ignoreValue.path);
        }
        ignoreExpressions.forEach(arg_0 -> ((JsonMessageValidationContext.Builder)this.jsonValidationContext).ignore(arg_0));
        this.builder.validate((ValidationContext.Builder)this.jsonValidationContext);
        JsonPathMessageValidationContext.Builder jsonPathContext = new JsonPathMessageValidationContext.Builder();
        HashMap<String, Object> validateJsonPathExpressions = new HashMap<String, Object>();
        for (Validate validateElement : this.getValidates()) {
            this.extractJsonPathValidateExpressions(validateElement, validateJsonPathExpressions);
        }
        if (!validateJsonPathExpressions.isEmpty()) {
            jsonPathContext.expressions(validateJsonPathExpressions);
            this.builder.validate((ValidationContext.Builder)jsonPathContext);
        }
    }

    private void extractJsonPathValidateExpressions(Validate validateElement, Map<String, Object> validateJsonPathExpressions) {
        String pathExpression = validateElement.path;
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            validateJsonPathExpressions.put(pathExpression, validateElement.value);
        }
        for (Validate.JsonPath jsonPathElement : validateElement.getJsonPaths()) {
            String expression = jsonPathElement.expression;
            if (!StringUtils.hasText((String)expression)) continue;
            validateJsonPathExpressions.put(expression, jsonPathElement.value);
        }
    }

    private void addXmlValidationContext() {
        HashSet<String> ignoreExpressions = new HashSet<String>();
        for (Ignore ignore : this.getIgnores()) {
            ignoreExpressions.add(ignore.path);
        }
        ignoreExpressions.forEach(arg_0 -> ((XmlMessageValidationContext.Builder)this.xmlValidationContext).ignore(arg_0));
        HashMap<String, String> validateNamespaces = new HashMap<String, String>();
        for (Validate validate : this.getValidates()) {
            for (Validate.Namespace namespaceElement : validate.getNamespaces()) {
                validateNamespaces.put(namespaceElement.prefix, namespaceElement.value);
            }
        }
        this.xmlValidationContext.namespaces(validateNamespaces);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Namespace namespace : this.getNamespaces()) {
            hashMap.put(namespace.prefix, namespace.value);
        }
        this.xmlValidationContext.setNamespaces(hashMap);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Validate validateElement : this.getValidates()) {
            this.extractXPathValidateExpressions(validateElement, hashMap2);
        }
        if (!hashMap2.isEmpty()) {
            this.builder.validate((ValidationContext.Builder)this.xmlValidationContext.xpath().expressions(hashMap2));
        } else {
            this.builder.validate((ValidationContext.Builder)this.xmlValidationContext);
        }
    }

    private void extractXPathValidateExpressions(Validate validateElement, Map<String, Object> validateXpathExpressions) {
        Object pathExpression = validateElement.path;
        if (StringUtils.hasText((String)pathExpression) && !JsonPathMessageValidationContext.isJsonPathExpression((String)pathExpression)) {
            if (validateElement.resultType != null) {
                pathExpression = validateElement.resultType + ":" + (String)pathExpression;
            }
            validateXpathExpressions.put((String)pathExpression, validateElement.value);
        }
        for (Validate.Xpath xpathElement : validateElement.getXpaths()) {
            Object expression = xpathElement.expression;
            if (!StringUtils.hasText((String)expression)) continue;
            if (xpathElement.resultType != null) {
                expression = xpathElement.resultType + ":" + (String)expression;
            }
            validateXpathExpressions.put((String)expression, xpathElement.value);
        }
    }

    @XmlElement
    public Receive setExtract(Message.Extract value) {
        MessageSupport.configureExtract(this.builder, value);
        return this;
    }

    @XmlAttribute
    public Receive setEndpoint(String value) {
        this.builder.endpoint(value);
        return this;
    }

    @XmlAttribute
    public Receive setActor(String value) {
        this.actor = value;
        return this;
    }

    @XmlAttribute
    public Receive setTimeout(Integer value) {
        this.builder.timeout((long)value.intValue());
        return this;
    }

    @XmlAttribute
    public Receive setSelect(String value) {
        this.builder.selector(value);
        return this;
    }

    @XmlElement
    public Receive setSelector(Selector selector) {
        if (selector.selectorValue != null) {
            this.builder.selector(selector.selectorValue);
        }
        if (selector.elements != null) {
            HashMap<String, String> selectorElements = new HashMap<String, String>();
            for (Selector.Element element : selector.elements) {
                selectorElements.put(element.name, element.value);
            }
            this.builder.selector(selectorElements);
        }
        return this;
    }

    public ReceiveMessageAction build() {
        if (this.referenceResolver != null && this.actor != null) {
            this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
        }
        this.validators.forEach(xva$0 -> this.builder.validator(new String[]{xva$0}));
        this.addXmlValidationContext();
        this.addJsonValidationContext();
        this.addScriptValidationContext();
        return this.doBuild();
    }

    protected ReceiveMessageAction doBuild() {
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.builder.setReferenceResolver(referenceResolver);
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"script", "xpaths", "jsonPaths", "namespaces"})
    public static class Validate {
        protected ScriptDefinitionType script;
        @XmlElement(name="xpath")
        protected List<Xpath> xpaths;
        @XmlElement(name="json-path")
        protected List<JsonPath> jsonPaths;
        @XmlElement(name="namespace")
        protected List<Namespace> namespaces;
        @XmlAttribute(name="path")
        protected String path;
        @XmlAttribute(name="value")
        protected String value;
        @XmlAttribute(name="result-type")
        protected String resultType;

        public ScriptDefinitionType getScript() {
            return this.script;
        }

        public void setScript(ScriptDefinitionType value) {
            this.script = value;
        }

        public List<Xpath> getXpaths() {
            if (this.xpaths == null) {
                this.xpaths = new ArrayList<Xpath>();
            }
            return this.xpaths;
        }

        public List<JsonPath> getJsonPaths() {
            if (this.jsonPaths == null) {
                this.jsonPaths = new ArrayList<JsonPath>();
            }
            return this.jsonPaths;
        }

        public List<Namespace> getNamespaces() {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList<Namespace>();
            }
            return this.namespaces;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getResultType() {
            return this.resultType;
        }

        public void setResultType(String value) {
            this.resultType = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Xpath {
            @XmlAttribute(name="expression", required=true)
            protected String expression;
            @XmlAttribute(name="value", required=true)
            protected String value;
            @XmlAttribute(name="result-type")
            protected String resultType;

            public String getExpression() {
                return this.expression;
            }

            public void setExpression(String value) {
                this.expression = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getResultType() {
                return this.resultType;
            }

            public void setResultType(String value) {
                this.resultType = value;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Namespace {
            @XmlAttribute(name="prefix", required=true)
            protected String prefix;
            @XmlAttribute(name="value", required=true)
            protected String value;

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String value) {
                this.prefix = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class JsonPath {
            @XmlAttribute(name="expression", required=true)
            protected String expression;
            @XmlAttribute(name="value", required=true)
            protected String value;

            public String getExpression() {
                return this.expression;
            }

            public void setExpression(String value) {
                this.expression = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Namespace {
        @XmlAttribute(name="prefix", required=true)
        protected String prefix;
        @XmlAttribute(name="value", required=true)
        protected String value;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String value) {
            this.prefix = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Ignore {
        @XmlAttribute(name="path", required=true)
        protected String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"elements", "selectorValue"})
    public static class Selector {
        @XmlElement(name="element")
        protected List<Element> elements;
        @XmlElement(name="value")
        protected String selectorValue;

        public List<Element> getElements() {
            if (this.elements == null) {
                this.elements = new ArrayList<Element>();
            }
            return this.elements;
        }

        public String getSelectorValue() {
            return this.selectorValue;
        }

        public void setSelectorValue(String value) {
            this.selectorValue = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Element {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value", required=true)
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

