/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface XmlTestActionBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(XmlTestActionBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/xml/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/xml/builder");

    public static Optional<TestActionBuilder<?>> lookup(String builder) {
        return XmlTestActionBuilder.lookup(builder, null);
    }

    public static Optional<TestActionBuilder<?>> lookup(String name, String namespace) {
        try {
            TestActionBuilder builder = (TestActionBuilder)TYPE_RESOLVER.resolve(name, new Object[0]);
            if (namespace != null && !namespace.equals(TYPE_RESOLVER.resolveProperty(name, "ns"))) {
                throw new CitrusRuntimeException(String.format("Namespace mismatch for given action builder '%s/%s'", RESOURCE_PATH, name));
            }
            return Optional.of(builder);
        }
        catch (CitrusRuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Failed to resolve test action builder from resource '%s/%s'", RESOURCE_PATH, name), (Throwable)e);
            } else {
                LOG.warn(String.format("Failed to resolve test action builder from resource '%s/%s'", RESOURCE_PATH, name));
            }
            return Optional.empty();
        }
    }
}

