/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.container;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.Template;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.xml.TestActions;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="template")
public class Template
implements TestActionBuilder<com.consol.citrus.container.Template>,
ReferenceResolverAware {
    private final Template.Builder builder = new Template.Builder();
    private ReferenceResolver referenceResolver;

    public com.consol.citrus.container.Template build() {
        this.builder.getActions().stream().filter(action -> action instanceof ReferenceResolverAware).forEach(action -> ((ReferenceResolverAware)action).setReferenceResolver(this.referenceResolver));
        return this.builder.build();
    }

    @XmlElement
    public Template setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    @XmlAttribute(name="name")
    public Template setTemplateName(String name) {
        this.builder.name(String.format("template:%s", name));
        this.builder.templateName(name);
        return this;
    }

    @XmlAttribute(name="global-context")
    public Template setGlobalContext(boolean globalContext) {
        this.builder.globalContext(globalContext);
        return this;
    }

    @XmlElement
    public Template setParameters(Parameters parameters) {
        parameters.getParameters().forEach(p -> {
            if (p.multilineValue != null) {
                this.builder.parameter(p.name, p.multilineValue);
            } else if (p.value != null) {
                this.builder.parameter(p.name, p.value);
            }
        });
        return this;
    }

    @XmlElement
    public Template setActions(TestActions actions) {
        this.builder.actions((TestActionBuilder[])actions.getActionBuilders().toArray(TestActionBuilder[]::new));
        return this;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"parameters"})
    public static class Parameters {
        @XmlElement(name="parameter")
        protected List<Parameter> parameters;

        public List<Parameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            return this.parameters;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class Parameter {
            @XmlElement(name="value")
            protected String multilineValue;
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute
            protected String value = "";

            public String getMultilineValue() {
                return this.multilineValue;
            }

            public void setMultilineValue(String value) {
                this.multilineValue = value;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

