/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.container;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.condition.ActionCondition;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.condition.FileCondition;
import com.consol.citrus.condition.HttpCondition;
import com.consol.citrus.condition.MessageCondition;
import com.consol.citrus.container.Wait;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.xml.TestActions;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.util.StringUtils;

@XmlRootElement(name="wait-for")
public class WaitFor
implements TestActionBuilder<Wait>,
ReferenceResolverAware {
    private final Wait.Builder builder = new Wait.Builder();
    private TestActionBuilder<?> action;
    private ReferenceResolver referenceResolver;

    public Wait build() {
        if (this.action != null) {
            if (this.action instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.action).setReferenceResolver(this.referenceResolver);
            }
            ActionCondition condition = new ActionCondition();
            condition.setAction(this.action.build());
            this.builder.condition((Condition)condition);
        }
        return this.builder.build();
    }

    @XmlElement
    public WaitFor setDescription(String value) {
        this.builder.description(value);
        return this;
    }

    @XmlElement
    public WaitFor setAction(TestActions action) {
        this.action = (TestActionBuilder)action.getActions().get(0);
        return this;
    }

    @XmlElement
    public WaitFor setMessage(Message message) {
        MessageCondition condition = new MessageCondition();
        condition.setMessageName(message.name);
        this.builder.condition((Condition)condition);
        return this;
    }

    @XmlElement
    public WaitFor setFile(File file) {
        FileCondition condition = new FileCondition();
        condition.setFilePath(file.path);
        this.builder.condition((Condition)condition);
        return this;
    }

    @XmlElement
    public WaitFor setHttp(Http http) {
        String timeout;
        String statusCode;
        HttpCondition condition = new HttpCondition();
        condition.setUrl(http.url);
        String method = http.method;
        if (StringUtils.hasText((String)method)) {
            condition.setMethod(method);
        }
        if (StringUtils.hasText((String)(statusCode = http.status))) {
            condition.setHttpResponseCode(statusCode);
        }
        if (StringUtils.hasText((String)(timeout = http.timeout))) {
            condition.setTimeout(timeout);
        }
        this.builder.condition((Condition)condition);
        return this;
    }

    @XmlAttribute
    public WaitFor setTimeout(String milliseconds) {
        this.builder.milliseconds(milliseconds);
        return this;
    }

    @XmlAttribute
    public WaitFor setInterval(String interval) {
        this.builder.interval(interval);
        return this;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Message {
        @XmlAttribute(name="name", required=true)
        protected String name;

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class Http {
        @XmlAttribute(name="url")
        protected String url;
        @XmlAttribute(name="method")
        protected String method;
        @XmlAttribute(name="status")
        protected String status;
        @XmlAttribute(name="timeout")
        protected String timeout;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String value) {
            this.url = value;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String value) {
            this.method = value;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String value) {
            this.status = value;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String value) {
            this.timeout = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class File {
        @XmlAttribute(name="path", required=true)
        protected String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String value) {
            this.path = value;
        }
    }
}

