/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.util;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PayloadElementParser {
    private PayloadElementParser() {
    }

    public static String parseMessagePayload(Element payloadElement) {
        if (payloadElement == null) {
            return "";
        }
        try {
            Document payload = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            payload.appendChild(payload.importNode(payloadElement, true));
            String payloadData = PayloadElementParser.serialize(payload);
            payloadData = payloadData.replaceAll(String.format(" %s", "http://citrusframework.org/schema/xml/testcase"), "");
            payloadData = payloadData.replaceAll(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
            return payloadData.trim();
        }
        catch (ParserConfigurationException | TransformerException | DOMException e) {
            throw new CitrusRuntimeException("Error while constructing message payload", (Throwable)e);
        }
    }

    private static String serialize(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

