/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mvn.plugin;

import com.consol.citrus.docs.ExcelTestDocsGenerator;
import com.consol.citrus.docs.HtmlTestDocsGenerator;
import com.consol.citrus.mvn.plugin.AbstractCitrusMojo;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-docs", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class GenerateDocsMojo
extends AbstractCitrusMojo {
    @Parameter(property="citrus.skip.generate.docs", defaultValue="false")
    protected boolean skipGenerateDocs;
    private final ExcelTestDocsGenerator excelTestDocGenerator;
    private final HtmlTestDocsGenerator htmlTestDocGenerator;

    public GenerateDocsMojo() {
        this(new ExcelTestDocsGenerator(), new HtmlTestDocsGenerator());
    }

    public GenerateDocsMojo(ExcelTestDocsGenerator excelTestDocGenerator, HtmlTestDocsGenerator htmlTestDocGenerator) {
        this.excelTestDocGenerator = excelTestDocGenerator;
        this.htmlTestDocGenerator = htmlTestDocGenerator;
    }

    @Override
    public void doExecute() throws MojoExecutionException {
        ExcelTestDocsGenerator generator;
        if (this.skipGenerateDocs) {
            return;
        }
        if (this.getDocs().getExcel() != null) {
            generator = this.getExcelTestDocGenerator();
            generator.withOutputFile(this.getDocs().getExcel().getOutputFile() + (this.getDocs().getExcel().getOutputFile().endsWith(".xls") ? "" : ".xls")).withPageTitle(this.getDocs().getExcel().getPageTitle()).withAuthor(this.getDocs().getExcel().getAuthor()).withCompany(this.getDocs().getExcel().getCompany()).useSrcDirectory(this.getTestSrcDirectory()).withCustomHeaders(this.getDocs().getExcel().getHeaders());
            generator.generateDoc();
            this.getLog().info((CharSequence)("Successfully created Excel documentation: outputFile='target/" + this.getDocs().getExcel().getOutputFile() + (this.getDocs().getExcel().getOutputFile().endsWith(".xls") ? "" : ".xls") + "'"));
        }
        if (this.getDocs().getHtml() != null) {
            generator = this.getHtmlTestDocGenerator();
            generator.withOutputFile(this.getDocs().getHtml().getOutputFile() + (this.getDocs().getHtml().getOutputFile().endsWith(".html") ? "" : ".html")).withPageTitle(this.getDocs().getHtml().getPageTitle()).withOverviewTitle(this.getDocs().getHtml().getHeading()).withColumns(this.getDocs().getHtml().getColumns()).useSrcDirectory(this.getTestSrcDirectory()).withLogo(this.getDocs().getHtml().getLogo());
            generator.generateDoc();
            this.getLog().info((CharSequence)("Successfully created HTML documentation: outputFile='target/" + this.getDocs().getHtml().getOutputFile() + (this.getDocs().getHtml().getOutputFile().endsWith(".html") ? "" : ".html") + "'"));
        }
    }

    public HtmlTestDocsGenerator getHtmlTestDocGenerator() {
        return Optional.ofNullable(this.htmlTestDocGenerator).orElse(HtmlTestDocsGenerator.build());
    }

    public ExcelTestDocsGenerator getExcelTestDocGenerator() {
        return Optional.ofNullable(this.excelTestDocGenerator).orElse(ExcelTestDocsGenerator.build());
    }
}

