/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mvn.plugin;

import com.consol.citrus.generate.SwaggerTestGenerator;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.UnitFramework;
import com.consol.citrus.generate.WsdlTestGenerator;
import com.consol.citrus.generate.XsdTestGenerator;
import com.consol.citrus.generate.javadsl.JavaDslTestGenerator;
import com.consol.citrus.generate.javadsl.SwaggerJavaTestGenerator;
import com.consol.citrus.generate.javadsl.WsdlJavaTestGenerator;
import com.consol.citrus.generate.javadsl.XsdJavaTestGenerator;
import com.consol.citrus.generate.xml.SwaggerXmlTestGenerator;
import com.consol.citrus.generate.xml.WsdlXmlTestGenerator;
import com.consol.citrus.generate.xml.XmlTestGenerator;
import com.consol.citrus.generate.xml.XsdXmlTestGenerator;
import com.consol.citrus.mvn.plugin.AbstractCitrusMojo;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.springframework.util.StringUtils;

@Mojo(name="create-test")
public class CreateTestMojo
extends AbstractCitrusMojo {
    @Parameter(property="citrus.skip.create.test", defaultValue="false")
    protected boolean skipCreateTest;
    @Component
    private Prompter prompter;
    private final XmlTestGenerator xmlTestGenerator;
    private final XsdXmlTestGenerator xsdXmlTestGenerator;
    private final WsdlXmlTestGenerator wsdlXmlTestGenerator;
    private final SwaggerXmlTestGenerator swaggerXmlTestGenerator;
    private final JavaDslTestGenerator javaTestGenerator;
    private final XsdJavaTestGenerator xsdJavaTestGenerator;
    private final WsdlJavaTestGenerator wsdlJavaTestGenerator;
    private final SwaggerJavaTestGenerator swaggerJavaTestGenerator;

    public CreateTestMojo() {
        this(new XmlTestGenerator(), new XsdXmlTestGenerator(), new WsdlXmlTestGenerator(), new SwaggerXmlTestGenerator(), new JavaDslTestGenerator(), new XsdJavaTestGenerator(), new WsdlJavaTestGenerator(), new SwaggerJavaTestGenerator());
    }

    public CreateTestMojo(XmlTestGenerator xmlTestGenerator, XsdXmlTestGenerator xsdXmlTestGenerator, WsdlXmlTestGenerator wsdlXmlTestGenerator, SwaggerXmlTestGenerator swaggerXmlTestGenerator, JavaDslTestGenerator javaTestGenerator, XsdJavaTestGenerator xsdJavaTestGenerator, WsdlJavaTestGenerator wsdlJavaTestGenerator, SwaggerJavaTestGenerator swaggerJavaTestGenerator) {
        this.xmlTestGenerator = xmlTestGenerator;
        this.xsdXmlTestGenerator = xsdXmlTestGenerator;
        this.wsdlXmlTestGenerator = wsdlXmlTestGenerator;
        this.swaggerXmlTestGenerator = swaggerXmlTestGenerator;
        this.javaTestGenerator = javaTestGenerator;
        this.xsdJavaTestGenerator = xsdJavaTestGenerator;
        this.wsdlJavaTestGenerator = wsdlJavaTestGenerator;
        this.swaggerJavaTestGenerator = swaggerJavaTestGenerator;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipCreateTest) {
            return;
        }
        try {
            String name = null;
            while (!StringUtils.hasText(name)) {
                name = this.prompter.prompt("Enter test name:");
            }
            if (!StringUtils.hasText(name)) {
                throw new MojoExecutionException("Please provide proper test name! Test name must not be empty starting with uppercase letter!");
            }
            String author = this.prompter.prompt("Enter test author:", "Unknown");
            String description = this.prompter.prompt("Enter test description:", "");
            String targetPackage = this.prompter.prompt("Enter test package:", "com.consol.citrus");
            String framework = this.prompter.prompt("Choose unit test framework:", Arrays.asList("testng", "junit4", "junit5"), UnitFramework.TESTNG.name().toLowerCase());
            String type = this.prompter.prompt("Choose target code base type:", Arrays.asList("java", "xml"), "java");
            this.setType(type);
            String useXsd = this.prompter.prompt("Create test with XML schema?", Arrays.asList("y", "n"), "n");
            if (useXsd.equalsIgnoreCase("y")) {
                XsdTestGenerator generator = this.getXsdTestGenerator();
                generator.withFramework(UnitFramework.fromString((String)framework)).withName(name).withAuthor(author).withDescription(description).usePackage(targetPackage);
                this.createWithXsd(generator);
                return;
            }
            String useWsdl = this.prompter.prompt("Create test with WSDL?", Arrays.asList("y", "n"), "n");
            if (useWsdl.equalsIgnoreCase("y")) {
                WsdlTestGenerator generator = this.getWsdlTestGenerator();
                generator.withFramework(UnitFramework.fromString((String)framework)).withName(name).withAuthor(author).withDescription(description).usePackage(targetPackage);
                this.createWithWsdl(generator);
                return;
            }
            String useSwagger = this.prompter.prompt("Create test with Swagger API?", Arrays.asList("y", "n"), "n");
            if (useSwagger.equalsIgnoreCase("y")) {
                SwaggerTestGenerator generator = this.getSwaggerTestGenerator();
                generator.withFramework(UnitFramework.fromString((String)framework)).withName(name).withAuthor(author).withDescription(description).usePackage(targetPackage);
                this.createWithSwagger(generator);
                return;
            }
            String confirm = this.prompter.prompt("Confirm test creation:\ntype: " + this.getType() + "\nframework: " + framework + "\nname: " + name + "\nauthor: " + author + "\ndescription: " + description + "\npackage: " + targetPackage + "\n", Arrays.asList("y", "n"), "y");
            if (confirm.equalsIgnoreCase("n")) {
                return;
            }
            if (this.getType().equals("java")) {
                JavaDslTestGenerator generator = (JavaDslTestGenerator)this.getJavaTestGenerator().withFramework(UnitFramework.fromString((String)framework)).withName(name).withAuthor(author).withDescription(description).usePackage(targetPackage);
                generator.create();
            } else {
                XmlTestGenerator generator = (XmlTestGenerator)this.getXmlTestGenerator().withFramework(UnitFramework.fromString((String)framework)).withName(name).withAuthor(author).withDescription(description).usePackage(targetPackage);
                generator.create();
            }
            this.getLog().info((CharSequence)("Successfully created new test case " + targetPackage + "." + name));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getLog().info((CharSequence)"Wrong parameter usage! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
        catch (PrompterException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Failed to create test! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
    }

    public void createWithXsd(XsdTestGenerator generator) throws MojoExecutionException {
        try {
            String xsd = null;
            while (!StringUtils.hasText(xsd)) {
                xsd = this.prompter.prompt("Enter path to XSD");
            }
            generator.withXsd(xsd);
            String xsdRequestMessage = this.prompter.prompt("Enter request element name");
            generator.withRequestMessage(xsdRequestMessage);
            String xsdResponseMessage = this.prompter.prompt("Enter response element name", generator.getResponseMessageSuggestion());
            generator.withResponseMessage(xsdResponseMessage);
            String mode = this.prompter.prompt("Choose mode:", Arrays.stream(TestGenerator.GeneratorMode.values()).map(Enum::name).collect(Collectors.toList()), TestGenerator.GeneratorMode.CLIENT.name());
            generator.withMode(TestGenerator.GeneratorMode.valueOf((String)mode.toUpperCase()));
            String confirm = this.prompter.prompt("Confirm test creation:\ntype: " + this.getType() + "\nframework: " + generator.getFramework() + "\nname: " + generator.getName() + "\nauthor: " + generator.getAuthor() + "\ndescription: " + generator.getDescription() + "\nxsd: " + generator.getXsd() + "\nrequest: " + generator.getRequestMessage() + "\nresponse: " + generator.getResponseMessage() + "\nactor: " + generator.getMode() + "\npackage: " + generator.getTargetPackage() + "\n", Arrays.asList("y", "n"), "y");
            if (confirm.equalsIgnoreCase("n")) {
                return;
            }
            generator.create();
            this.getLog().info((CharSequence)("Successfully created new test case " + generator.getTargetPackage() + "." + generator.getName()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getLog().info((CharSequence)"Wrong parameter usage! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
        catch (PrompterException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Failed to create test! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
    }

    public void createWithWsdl(WsdlTestGenerator generator) throws MojoExecutionException {
        try {
            String wsdl = null;
            while (!StringUtils.hasText(wsdl)) {
                wsdl = this.prompter.prompt("Enter path to WSDL");
            }
            if (!StringUtils.hasText(wsdl)) {
                throw new MojoExecutionException("Please provide proper path to WSDL file");
            }
            generator.withWsdl(wsdl);
            String mode = this.prompter.prompt("Choose mode:", Arrays.stream(TestGenerator.GeneratorMode.values()).map(Enum::name).collect(Collectors.toList()), TestGenerator.GeneratorMode.CLIENT.name());
            generator.withMode(TestGenerator.GeneratorMode.valueOf((String)mode.toUpperCase()));
            String operation = this.prompter.prompt("Enter operation name", "all");
            if (!operation.equals("all")) {
                generator.withOperation(operation);
            }
            String namePrefix = this.prompter.prompt("Enter test name prefix", generator.getName() + "_");
            generator.withNamePrefix(namePrefix);
            String nameSuffix = this.prompter.prompt("Enter test name suffix", generator.getNameSuffix());
            generator.withNameSuffix(nameSuffix);
            String confirm = this.prompter.prompt("Confirm test creation:\ntype: " + this.getType() + "\nframework: " + generator.getFramework() + "\nname: " + generator.getName() + "\nauthor: " + generator.getAuthor() + "\ndescription: " + generator.getDescription() + "\nwsdl: " + generator.getWsdl() + "\noperation: " + Optional.ofNullable(generator.getOperation()).orElse("all") + "\nactor: " + generator.getMode() + "\npackage: " + generator.getTargetPackage() + "\n", Arrays.asList("y", "n"), "y");
            if (confirm.equalsIgnoreCase("n")) {
                return;
            }
            generator.create();
            this.getLog().info((CharSequence)"Successfully created new test cases from WSDL");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Wrong parameter usage! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
        catch (PrompterException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Failed to create suite! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
    }

    public void createWithSwagger(SwaggerTestGenerator generator) throws MojoExecutionException {
        try {
            String swagger = null;
            while (!StringUtils.hasText(swagger)) {
                swagger = this.prompter.prompt("Enter path to Swagger API");
            }
            if (!StringUtils.hasText(swagger)) {
                throw new MojoExecutionException("Please provide proper path to Swagger API file");
            }
            generator.withSpec(swagger);
            String mode = this.prompter.prompt("Choose mode:", Arrays.stream(TestGenerator.GeneratorMode.values()).map(Enum::name).collect(Collectors.toList()), TestGenerator.GeneratorMode.CLIENT.name());
            generator.withMode(TestGenerator.GeneratorMode.valueOf((String)mode.toUpperCase()));
            String operation = this.prompter.prompt("Enter operation name", "all");
            if (!operation.equals("all")) {
                generator.withOperation(operation);
            }
            String namePrefix = this.prompter.prompt("Enter test name prefix", generator.getName() + "_");
            generator.withNamePrefix(namePrefix);
            String nameSuffix = this.prompter.prompt("Enter test name suffix", generator.getNameSuffix());
            generator.withNameSuffix(nameSuffix);
            String confirm = this.prompter.prompt("Confirm test creation:\ntype: " + this.getType() + "\nframework: " + generator.getFramework() + "\nname: " + generator.getName() + "\nauthor: " + generator.getAuthor() + "\ndescription: " + generator.getDescription() + "\nswagger-api: " + generator.getSwaggerResource() + "\noperation: " + Optional.ofNullable(generator.getOperation()).orElse("all") + "\nactor: " + generator.getMode() + "\npackage: " + generator.getTargetPackage() + "\n", Arrays.asList("y", "n"), "y");
            if (confirm.equalsIgnoreCase("n")) {
                return;
            }
            generator.create();
            this.getLog().info((CharSequence)"Successfully created new test cases from Swagger API");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Wrong parameter usage! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
        catch (PrompterException e) {
            this.getLog().info((Throwable)e);
            this.getLog().info((CharSequence)"Failed to create suite! See citrus:help for usage details (mvn citrus:help -Ddetail=true -Dgoal=create-test).");
        }
    }

    public XmlTestGenerator getXmlTestGenerator() {
        return Optional.ofNullable(this.xmlTestGenerator).orElse(new XmlTestGenerator());
    }

    public JavaDslTestGenerator getJavaTestGenerator() {
        return Optional.ofNullable(this.javaTestGenerator).orElse(new JavaDslTestGenerator());
    }

    public SwaggerTestGenerator getSwaggerTestGenerator() {
        if (this.getType().equals("java")) {
            return (SwaggerTestGenerator)Optional.ofNullable(this.swaggerJavaTestGenerator).orElse(new SwaggerJavaTestGenerator());
        }
        return (SwaggerTestGenerator)Optional.ofNullable(this.swaggerXmlTestGenerator).orElse(new SwaggerXmlTestGenerator());
    }

    public WsdlTestGenerator getWsdlTestGenerator() {
        if (this.getType().equals("java")) {
            return (WsdlTestGenerator)Optional.ofNullable(this.wsdlJavaTestGenerator).orElse(new WsdlJavaTestGenerator());
        }
        return (WsdlTestGenerator)Optional.ofNullable(this.wsdlXmlTestGenerator).orElse(new WsdlXmlTestGenerator());
    }

    public XsdTestGenerator getXsdTestGenerator() {
        if (this.getType().equals("java")) {
            return (XsdTestGenerator)Optional.ofNullable(this.xsdJavaTestGenerator).orElse(new XsdJavaTestGenerator());
        }
        return (XsdTestGenerator)Optional.ofNullable(this.xsdXmlTestGenerator).orElse(new XsdXmlTestGenerator());
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }
}

