/*
 * Decompiled with CFR 0.152.
 */
package com.contaazul.dsl;

import com.contaazul.dsl.DateDsl;
import com.contaazul.dsl.Months;
import com.contaazul.dsl.TimeUnit;
import com.contaazul.dsl.WeekDays;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateBuilder {
    private final Calendar date = Calendar.getInstance();

    public DateBuilder() {
    }

    public DateBuilder(Calendar calendar) {
        this.date.setTime(calendar.getTime());
    }

    public DateBuilder(Date date) {
        this.date.setTime(date);
    }

    public DateBuilder add(TimeUnit unit) {
        if (unit.workingDay) {
            int nbDay = unit.size;
            int i = 0;
            while (i != nbDay) {
                this.date.add(unit.type, 1);
                if (this.isWeekend()) continue;
                ++i;
            }
        } else {
            this.date.add(unit.type, unit.size);
        }
        return this;
    }

    public DateBuilder clearTime() {
        this.date.set(11, 0);
        this.date.clear(12);
        this.date.clear(13);
        this.date.clear(14);
        return this;
    }

    public DateBuilder endOfDay() {
        this.date.set(11, 23);
        this.date.set(12, 59);
        this.date.set(13, 59);
        this.date.set(14, 999);
        return this;
    }

    public DateBuilder firstDayOfMonth() {
        this.date.set(5, 1);
        return this;
    }

    public DateBuilder firstDayOfNextMonth() {
        this.firstDayOfMonth().add(DateDsl.months(1));
        return this;
    }

    public String format(String dateFormat) {
        return new SimpleDateFormat(dateFormat).format(this.date.getTime());
    }

    public int getDayOfMonth() {
        return this.date.get(5);
    }

    public int getDayOfWeek() {
        return this.date.get(7);
    }

    public int getHour() {
        return this.date.get(10);
    }

    public int getHourOfDay() {
        return this.date.get(11);
    }

    public int getMillisecond() {
        return this.date.get(14);
    }

    public int getMinute() {
        return this.date.get(12);
    }

    public int getMonth() {
        return this.date.get(2);
    }

    public Months getMonths() {
        return Months.values()[this.date.get(2)];
    }

    public int getSecond() {
        return this.date.get(13);
    }

    public WeekDays getWeekDay() {
        return WeekDays.values()[this.date.get(7)];
    }

    public int getWeekMonth() {
        return this.date.get(4);
    }

    public int getWeekYear() {
        return this.date.get(3);
    }

    public int getYear() {
        return this.date.get(1);
    }

    public boolean isSameAs(Calendar calendar) {
        return this.date.getTime().getTime() == calendar.getTime().getTime();
    }

    public boolean isSameAs(Date dateToCompare) {
        return this.date.getTime().getTime() == dateToCompare.getTime();
    }

    public boolean isSameDayAs(Calendar calendar) {
        return this.date.get(0) == calendar.get(0) && this.date.get(1) == calendar.get(1) && this.date.get(6) == calendar.get(6);
    }

    public boolean isSameDayAs(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return this.isSameDayAs(calendar);
    }

    public boolean isSameTimeAs(Calendar calendar) {
        return this.date.get(10) == calendar.get(10) && this.date.get(12) == calendar.get(12) && this.date.get(13) == calendar.get(13) && this.date.get(14) == calendar.get(14);
    }

    public boolean isSameTimeAs(Date dateToCompare) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateToCompare);
        return this.isSameTimeAs(calendar);
    }

    public boolean isWeekend() {
        return this.date.get(7) == 7 || this.date.get(7) == 1;
    }

    public DateBuilder lastDayOfMonth() {
        this.date.set(5, this.date.getActualMaximum(5));
        return this;
    }

    public DateBuilder lastDayOfNextMonth() {
        this.add(DateDsl.months(1)).lastDayOfMonth();
        return this;
    }

    public DateBuilder setAsEqual(Calendar calendar) {
        calendar.setTime(this.date.getTime());
        return this;
    }

    public DateBuilder setAsEqual(Date dateExt) {
        dateExt.setTime(this.date.getTime().getTime());
        return this;
    }

    public DateBuilder subtract(TimeUnit unit) {
        this.date.add(unit.type, -unit.size);
        return this;
    }

    public Calendar toCalendar() {
        return this.date;
    }

    public Date toDate() {
        return this.date.getTime();
    }

    public String toLongStringDate() {
        return null;
    }

    public String toShortStringDate() {
        return null;
    }

    public String toString() {
        return this.date.getTime().toString();
    }

    public String toStringDate() {
        return null;
    }

    public DateBuilder withDayOfMonth(int day) {
        this.date.set(5, day);
        return this;
    }

    public DateBuilder withDayOfWeek(int day) {
        this.date.set(7, day);
        return this;
    }

    public DateBuilder withDayOfWeek(WeekDays day) {
        this.date.set(7, day.calendaWeekday);
        return this;
    }

    public DateBuilder withHour(int hour) {
        this.date.set(10, hour);
        return this;
    }

    public DateBuilder withHourOfDay(int hour) {
        this.date.set(11, hour);
        return this;
    }

    public DateBuilder withMillisecond(int millisecond) {
        this.date.set(14, millisecond);
        return this;
    }

    public DateBuilder withMinute(int minute) {
        this.date.set(12, minute);
        return this;
    }

    public DateBuilder withMonth(int month) {
        this.date.set(2, month);
        return this;
    }

    public DateBuilder withMonth(Months month) {
        this.date.set(2, month.calendaMonth);
        return this;
    }

    public DateBuilder withSecond(int second) {
        this.date.set(13, second);
        return this;
    }

    public DateBuilder withYear(int year) {
        this.date.set(1, year);
        return this;
    }

    public boolean isFuture() {
        return this.date.after(Calendar.getInstance());
    }

    public boolean isPast() {
        return this.date.before(Calendar.getInstance());
    }

    public boolean before(Calendar dt) {
        return this.date.before(dt);
    }

    public boolean before(DateBuilder dt) {
        return this.before(dt.toCalendar());
    }

    public boolean before(Date dt) {
        return this.before(DateDsl.date(dt));
    }

    public boolean after(Calendar dt) {
        return this.date.after(dt);
    }

    public boolean after(DateBuilder dt) {
        return this.after(dt.toCalendar());
    }

    public boolean after(Date dt) {
        return this.after(DateDsl.date(dt));
    }

    public boolean isToday() {
        return this.isSameDayAs(new Date());
    }
}

