/*
 * Decompiled with CFR 0.152.
 */
package com.contaazul.dsl;

import com.contaazul.dsl.DateBuilder;
import com.contaazul.dsl.Months;
import com.contaazul.dsl.TimeRange;
import com.contaazul.dsl.TimeUnit;
import java.util.Calendar;
import java.util.Date;

public class DateDsl {
    public static final String FORMAT_ = "";

    public static DateBuilder date() {
        return new DateBuilder();
    }

    public static DateBuilder date(Calendar calendar) {
        return new DateBuilder(calendar);
    }

    public static DateBuilder date(Date date) {
        return new DateBuilder(date);
    }

    public static DateBuilder date(int year, int monthOfYear, int dayOfMonth) {
        return DateDsl.date(year, monthOfYear, dayOfMonth, 0, 0, 0, 0);
    }

    public static DateBuilder date(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        DateBuilder db = new DateBuilder();
        db.withYear(year);
        db.withMonth(monthOfYear);
        db.withDayOfMonth(dayOfMonth);
        db.withHourOfDay(hourOfDay);
        db.withMinute(minuteOfHour);
        db.withSecond(secondOfMinute);
        db.withMillisecond(millisOfSecond);
        return db;
    }

    public static DateBuilder date(int year, Months monthOfYear, int dayOfMonth) {
        return DateDsl.date(year, monthOfYear, dayOfMonth, 0, 0, 0, 0);
    }

    public static DateBuilder date(int year, Months monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        DateBuilder db = new DateBuilder();
        db.withYear(year);
        db.withMonth(monthOfYear);
        db.withDayOfMonth(dayOfMonth);
        db.withHourOfDay(hourOfDay);
        db.withMinute(minuteOfHour);
        db.withSecond(secondOfMinute);
        db.withMillisecond(millisOfSecond);
        return db;
    }

    public static TimeUnit day() {
        return DateDsl.days(1);
    }

    public static TimeUnit days(int n) {
        return new TimeUnit(5, n);
    }

    public static TimeUnit week() {
        return DateDsl.weeks(1);
    }

    public static TimeUnit weeks(int n) {
        return new TimeUnit(4, n);
    }

    public static DateBuilder emptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        return new DateBuilder(cal.getTime());
    }

    public static TimeUnit hour() {
        return DateDsl.hours(1);
    }

    public static TimeUnit hours(int n) {
        return new TimeUnit(10, n);
    }

    public static TimeUnit milliSecond() {
        return DateDsl.milliSecondes(1);
    }

    public static TimeUnit milliSecondes(int n) {
        return new TimeUnit(14, n);
    }

    public static TimeUnit minute() {
        return DateDsl.minutes(1);
    }

    public static TimeUnit minutes(int n) {
        return new TimeUnit(12, n);
    }

    public static TimeUnit month() {
        return DateDsl.months(1);
    }

    public static TimeUnit months(int n) {
        return new TimeUnit(2, n);
    }

    public static TimeUnit months(Months n) {
        return new TimeUnit(2, n.calendaMonth);
    }

    public static DateBuilder now() {
        return new DateBuilder();
    }

    public static TimeRange range() {
        return new TimeRange();
    }

    public static TimeRange range(Calendar date, TimeUnit size) {
        return new TimeRange(date, size);
    }

    public static TimeRange range(Date date, TimeUnit size) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new TimeRange(cal, size);
    }

    public static TimeRange range(DateBuilder date, TimeUnit size) {
        return new TimeRange(date.toCalendar(), size);
    }

    public static TimeUnit second() {
        return DateDsl.secondes(1);
    }

    public static TimeUnit secondes(int n) {
        return new TimeUnit(13, n);
    }

    public static DateBuilder tomorrow() {
        DateBuilder date = new DateBuilder(new Date());
        return date.add(DateDsl.days(1));
    }

    public static TimeUnit workingDays(int n) {
        return new TimeUnit(5, n, true);
    }

    public static TimeUnit year() {
        return DateDsl.years(1);
    }

    public static TimeUnit years(int n) {
        return new TimeUnit(1, n);
    }

    public static DateBuilder yesterday() {
        DateBuilder date = new DateBuilder(new Date());
        return date.subtract(DateDsl.days(1));
    }
}

