/*
 * Decompiled with CFR 0.152.
 */
package com.contaazul.dsl;

import com.contaazul.dsl.DateBuilder;
import com.contaazul.dsl.DateDsl;
import com.contaazul.dsl.TimeUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeRange {
    private Calendar startDate;
    private Calendar endDate;

    public TimeRange() {
    }

    public TimeRange(Calendar calendar, TimeUnit size) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(this.startDate.getTime());
        this.endDate = Calendar.getInstance();
        this.endDate.setTime(this.startDate.getTime());
        this.endDate.add(size.type, size.size);
    }

    public boolean contains(Calendar date) {
        return !date.before(this.startDate) && !date.after(this.endDate);
    }

    public boolean contains(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return this.contains(calendar);
    }

    public boolean contains(DateBuilder date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date.toDate());
        return this.contains(calendar);
    }

    private int elapsed(int type) {
        GregorianCalendar gc1;
        GregorianCalendar gc2;
        int elapsed = 0;
        if (this.endDate.after(this.startDate)) {
            gc2 = (GregorianCalendar)this.endDate.clone();
            gc1 = (GregorianCalendar)this.startDate.clone();
        } else {
            gc2 = (GregorianCalendar)this.startDate.clone();
            gc1 = (GregorianCalendar)this.endDate.clone();
        }
        if (type == 2 || type == 1) {
            gc1.clear(5);
            gc2.clear(5);
        }
        if (type == 1) {
            gc1.clear(2);
            gc2.clear(2);
        }
        while (gc1.before(gc2)) {
            gc1.add(type, 1);
            ++elapsed;
        }
        return elapsed;
    }

    public TimeRange endWith(Calendar endDate) {
        this.endDate = Calendar.getInstance();
        this.endDate.setTime(endDate.getTime());
        return this;
    }

    public TimeRange endWith(Date endDate) {
        this.endDate = Calendar.getInstance();
        this.endDate.setTime(endDate);
        return this;
    }

    public TimeRange endWith(DateBuilder endDate) {
        this.endDate = Calendar.getInstance();
        this.endDate.setTime(endDate.toDate());
        return this;
    }

    public int getElapsedDays() {
        return this.elapsed(5);
    }

    public int getElapsedMonths() {
        return this.elapsed(2);
    }

    public int getElapsedYears() {
        return this.elapsed(1);
    }

    public int getElapsedWeeks() {
        return this.elapsed(4);
    }

    public boolean isDistinctFrom(TimeRange range) {
        return range.endDate.before(this.startDate) && range.startDate.before(this.startDate) || range.endDate.after(this.endDate) && range.startDate.after(this.endDate);
    }

    public TimeRange startWith(Calendar startDate) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(startDate.getTime());
        return this;
    }

    public TimeRange startWith(Date startDate) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(startDate);
        return this;
    }

    public TimeRange startWith(DateBuilder startDate) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(startDate.toDate());
        return this;
    }

    public int getMonthsBetween() {
        return this.roundDown(this.getElapsedMonths(), 2);
    }

    public int getWeeksBetween() {
        return this.roundDown(this.getElapsedWeeks(), 4);
    }

    private int roundDown(int value, int type) {
        if (DateDsl.date(this.startDate).add(new TimeUnit(type, value)).after(DateDsl.date(this.endDate))) {
            return value - 1;
        }
        return value;
    }
}

