/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.Logger;
import com.contentful.java.cma.ModuleApiKeys;
import com.contentful.java.cma.ModuleAssets;
import com.contentful.java.cma.ModuleContentTypes;
import com.contentful.java.cma.ModuleEditorInterfaces;
import com.contentful.java.cma.ModuleEntries;
import com.contentful.java.cma.ModuleEnvironments;
import com.contentful.java.cma.ModuleLocales;
import com.contentful.java.cma.ModuleOrganizations;
import com.contentful.java.cma.ModulePersonalAccessTokens;
import com.contentful.java.cma.ModulePreviewApiKeys;
import com.contentful.java.cma.ModuleRoles;
import com.contentful.java.cma.ModuleSpaceMemberships;
import com.contentful.java.cma.ModuleSpaces;
import com.contentful.java.cma.ModuleUiExtensions;
import com.contentful.java.cma.ModuleUploads;
import com.contentful.java.cma.ModuleUsers;
import com.contentful.java.cma.ModuleWebhooks;
import com.contentful.java.cma.Platform;
import com.contentful.java.cma.gson.EntrySerializer;
import com.contentful.java.cma.gson.FieldTypeAdapter;
import com.contentful.java.cma.gson.LocaleSerializer;
import com.contentful.java.cma.interceptor.AuthorizationHeaderInterceptor;
import com.contentful.java.cma.interceptor.ContentTypeInterceptor;
import com.contentful.java.cma.interceptor.ContentfulUserAgentHeaderInterceptor;
import com.contentful.java.cma.interceptor.ErrorInterceptor;
import com.contentful.java.cma.interceptor.LogInterceptor;
import com.contentful.java.cma.interceptor.RateLimitInterceptor;
import com.contentful.java.cma.interceptor.RateLimitsListener;
import com.contentful.java.cma.interceptor.UserAgentHeaderInterceptor;
import com.contentful.java.cma.model.CMAEntry;
import com.contentful.java.cma.model.CMAField;
import com.contentful.java.cma.model.CMALocale;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Properties;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class CMAClient {
    private static Gson gson;
    private final ModuleApiKeys moduleApiKeys;
    private final ModuleAssets moduleAssets;
    private final ModuleContentTypes moduleContentTypes;
    private final ModuleEditorInterfaces moduleEditorInterfaces;
    private final ModuleEntries moduleEntries;
    private final ModuleEnvironments moduleEnvironments;
    private final ModuleLocales moduleLocales;
    private final ModuleOrganizations moduleOrganizations;
    private final ModulePersonalAccessTokens modulePersonalAccessTokens;
    private final ModulePreviewApiKeys modulePreviewApiKeys;
    private final ModuleRoles moduleRoles;
    private final ModuleSpaceMemberships moduleSpaceMemberships;
    private final ModuleSpaces moduleSpaces;
    private final ModuleUiExtensions moduleUiExtensions;
    private final ModuleUploads moduleUploads;
    private final ModuleUsers moduleUsers;
    private final ModuleWebhooks moduleWebhooks;
    Executor callbackExecutor;

    private CMAClient(Builder cmaBuilder) {
        if (cmaBuilder.accessToken == null) {
            throw new IllegalArgumentException("No access token was set.");
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)CMAClient.createGson())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl("https://api.contentful.com/");
        retrofitBuilder = this.setEndpoint(retrofitBuilder, cmaBuilder.coreEndpoint);
        retrofitBuilder.callFactory((Call.Factory)(cmaBuilder.coreCallFactory == null ? cmaBuilder.defaultCoreCallFactoryBuilder().build() : cmaBuilder.coreCallFactory));
        this.setCallbackExecutor(cmaBuilder);
        Retrofit retrofit = retrofitBuilder.build();
        retrofitBuilder.baseUrl("https://upload.contentful.com/");
        retrofitBuilder = this.setEndpoint(retrofitBuilder, cmaBuilder.uploadEndpoint);
        retrofitBuilder.callFactory((Call.Factory)(cmaBuilder.uploadCallFactory == null ? cmaBuilder.defaultUploadCallFactoryBuilder().build() : cmaBuilder.uploadCallFactory));
        Retrofit uploadRetrofit = retrofitBuilder.build();
        String spaceId = cmaBuilder.spaceId;
        String environmentId = cmaBuilder.environmentId;
        boolean configured = cmaBuilder.environmentIdConfigured;
        this.moduleApiKeys = new ModuleApiKeys(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleAssets = new ModuleAssets(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleContentTypes = new ModuleContentTypes(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleEditorInterfaces = new ModuleEditorInterfaces(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleEntries = new ModuleEntries(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleEnvironments = new ModuleEnvironments(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleLocales = new ModuleLocales(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleOrganizations = new ModuleOrganizations(retrofit, this.callbackExecutor, configured);
        this.modulePersonalAccessTokens = new ModulePersonalAccessTokens(retrofit, this.callbackExecutor, configured);
        this.modulePreviewApiKeys = new ModulePreviewApiKeys(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleRoles = new ModuleRoles(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleSpaceMemberships = new ModuleSpaceMemberships(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleSpaces = new ModuleSpaces(retrofit, this.callbackExecutor, configured);
        this.moduleUiExtensions = new ModuleUiExtensions(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleUploads = new ModuleUploads(uploadRetrofit, this.callbackExecutor, spaceId, environmentId, configured);
        this.moduleUsers = new ModuleUsers(retrofit, this.callbackExecutor, configured);
        this.moduleWebhooks = new ModuleWebhooks(retrofit, this.callbackExecutor, spaceId, environmentId, configured);
    }

    static Gson createGson() {
        if (gson == null) {
            gson = new GsonBuilder().registerTypeAdapter(CMAField.class, (Object)new FieldTypeAdapter()).registerTypeAdapter(CMAEntry.class, (Object)new EntrySerializer()).registerTypeAdapter(CMALocale.class, (Object)new LocaleSerializer()).create();
        }
        return gson;
    }

    private void setCallbackExecutor(Builder clientBuilder) {
        this.callbackExecutor = clientBuilder.callbackExecutor == null ? Platform.get().callbackExecutor() : clientBuilder.callbackExecutor;
    }

    private Retrofit.Builder setEndpoint(Retrofit.Builder retrofitBuilder, String endpoint) {
        if (endpoint != null) {
            return retrofitBuilder.baseUrl(endpoint);
        }
        return retrofitBuilder;
    }

    public ModuleApiKeys apiKeys() {
        return this.moduleApiKeys;
    }

    public ModulePreviewApiKeys previewApiKeys() {
        return this.modulePreviewApiKeys;
    }

    public ModuleAssets assets() {
        return this.moduleAssets;
    }

    public ModuleContentTypes contentTypes() {
        return this.moduleContentTypes;
    }

    public ModuleEditorInterfaces editorInterfaces() {
        return this.moduleEditorInterfaces;
    }

    public ModuleEntries entries() {
        return this.moduleEntries;
    }

    public ModuleEnvironments environments() {
        return this.moduleEnvironments;
    }

    public ModuleOrganizations organizations() {
        return this.moduleOrganizations;
    }

    public ModulePersonalAccessTokens personalAccessTokens() {
        return this.modulePersonalAccessTokens;
    }

    public ModuleRoles roles() {
        return this.moduleRoles;
    }

    public ModuleSpaces spaces() {
        return this.moduleSpaces;
    }

    public ModuleWebhooks webhooks() {
        return this.moduleWebhooks;
    }

    public ModuleUsers users() {
        return this.moduleUsers;
    }

    public ModuleUiExtensions uiExtensions() {
        return this.moduleUiExtensions;
    }

    public ModuleSpaceMemberships spaceMemberships() {
        return this.moduleSpaceMemberships;
    }

    public ModuleUploads uploads() {
        return this.moduleUploads;
    }

    public ModuleLocales locales() {
        return this.moduleLocales;
    }

    public static class Builder {
        private String accessToken;
        private Call.Factory coreCallFactory;
        private Call.Factory uploadCallFactory;
        private Logger logger;
        private Logger.Level logLevel = Logger.Level.NONE;
        private String coreEndpoint;
        private String uploadEndpoint;
        private ContentfulUserAgentHeaderInterceptor.Section application;
        private ContentfulUserAgentHeaderInterceptor.Section integration;
        private String environmentId = "master";
        private boolean environmentIdConfigured = false;
        private String spaceId;
        private Executor callbackExecutor;
        private RateLimitsListener rateLimitListener;

        public Builder setCoreEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setCoreEndpoint() with null.");
            }
            this.coreEndpoint = remoteUrl;
            return this;
        }

        public Builder setUploadEndpoint(String remoteUrl) {
            if (remoteUrl == null) {
                throw new IllegalArgumentException("Cannot call setUploadEndpoint() with null.");
            }
            this.uploadEndpoint = remoteUrl;
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            if (accessToken == null) {
                throw new IllegalArgumentException("Cannot call setAccessToken() with null.");
            }
            this.accessToken = accessToken;
            return this;
        }

        public Builder setSpaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder setEnvironmentId(String environmentId) {
            this.environmentIdConfigured = true;
            this.environmentId = environmentId;
            return this;
        }

        public Builder setCoreCallFactory(Call.Factory callFactory) {
            if (callFactory == null) {
                throw new IllegalArgumentException("Cannot call setCallFactory() with null.");
            }
            this.coreCallFactory = callFactory;
            return this;
        }

        public Builder setUploadCallFactory(Call.Factory callFactory) {
            if (callFactory == null) {
                throw new IllegalArgumentException("Cannot call setCallFactory() with null.");
            }
            this.uploadCallFactory = callFactory;
            return this;
        }

        public Builder setCallbackExecutor(Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("Cannot call setCallbackExecutor() with null.");
            }
            this.callbackExecutor = executor;
            return this;
        }

        public Builder setLogger(Logger logger) {
            if (logger == null) {
                throw new IllegalArgumentException("Do not set a null logger");
            }
            this.logger = logger;
            return this;
        }

        public Builder setLogLevel(Logger.Level logLevel) {
            if (logLevel == null) {
                throw new IllegalArgumentException("Cannot call setLogLevel() with null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public Builder setApplication(String name, String version) {
            this.application = ContentfulUserAgentHeaderInterceptor.Section.app(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public Builder setIntegration(String name, String version) {
            this.integration = ContentfulUserAgentHeaderInterceptor.Section.integration(name, ContentfulUserAgentHeaderInterceptor.Section.Version.parse(version));
            return this;
        }

        public Builder setRateLimitListener(RateLimitsListener listener) {
            this.rateLimitListener = listener;
            return this;
        }

        public CMAClient build() {
            return new CMAClient(this);
        }

        public OkHttpClient.Builder defaultCoreCallFactoryBuilder() {
            OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(this.accessToken)).addInterceptor((Interceptor)new UserAgentHeaderInterceptor(this.getUserAgent())).addInterceptor((Interceptor)new ContentfulUserAgentHeaderInterceptor(this.createCustomHeaderSections(this.application, this.integration))).addInterceptor((Interceptor)new ContentTypeInterceptor("application/vnd.contentful.management.v1+json")).addInterceptor((Interceptor)new ErrorInterceptor());
            if (this.rateLimitListener != null) {
                okBuilder.addInterceptor((Interceptor)new RateLimitInterceptor(this.rateLimitListener));
            }
            return this.setLogger(okBuilder);
        }

        public OkHttpClient.Builder defaultUploadCallFactoryBuilder() {
            OkHttpClient.Builder okBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationHeaderInterceptor(this.accessToken)).addInterceptor((Interceptor)new UserAgentHeaderInterceptor(this.getUserAgent())).addInterceptor((Interceptor)new ContentfulUserAgentHeaderInterceptor(this.createCustomHeaderSections(this.application, this.integration))).addInterceptor((Interceptor)new ContentTypeInterceptor("application/octet-stream")).addInterceptor((Interceptor)new ErrorInterceptor());
            return this.setLogger(okBuilder);
        }

        private String getUserAgent() {
            return String.format("contentful-management.java/%s", "3.1.0");
        }

        ContentfulUserAgentHeaderInterceptor.Section[] createCustomHeaderSections(ContentfulUserAgentHeaderInterceptor.Section application, ContentfulUserAgentHeaderInterceptor.Section integration) {
            Properties properties = System.getProperties();
            return new ContentfulUserAgentHeaderInterceptor.Section[]{ContentfulUserAgentHeaderInterceptor.Section.sdk("contentful-management.java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse("3.1.0")), ContentfulUserAgentHeaderInterceptor.Section.platform("java", ContentfulUserAgentHeaderInterceptor.Section.Version.parse(properties.getProperty("java.runtime.version"))), ContentfulUserAgentHeaderInterceptor.Section.os(ContentfulUserAgentHeaderInterceptor.Section.OperatingSystem.parse(properties.getProperty("os.name")), ContentfulUserAgentHeaderInterceptor.Section.Version.parse(properties.getProperty("os.version"))), application, integration};
        }

        private OkHttpClient.Builder setLogger(OkHttpClient.Builder okBuilder) {
            block6: {
                block5: {
                    if (this.logger == null) break block5;
                    switch (this.logLevel) {
                        default: {
                            break block6;
                        }
                        case BASIC: {
                            return okBuilder.addInterceptor((Interceptor)new LogInterceptor(this.logger));
                        }
                        case FULL: {
                            return okBuilder.addNetworkInterceptor((Interceptor)new LogInterceptor(this.logger));
                        }
                    }
                }
                if (this.logLevel != Logger.Level.NONE) {
                    throw new IllegalArgumentException("Cannot log to a null logger. Please set either no logLevel or set a custom Logger");
                }
            }
            return okBuilder;
        }
    }
}

