/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceApiKeys;
import com.contentful.java.cma.model.CMAApiKey;
import com.contentful.java.cma.model.CMAArray;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ModuleApiKeys
extends AbsModule<ServiceApiKeys> {
    final Async async = new Async();

    public ModuleApiKeys(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceApiKeys createService(Retrofit retrofit) {
        return (ServiceApiKeys)retrofit.create(ServiceApiKeys.class);
    }

    public CMAArray<CMAApiKey> fetchAll() {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId);
    }

    public CMAArray<CMAApiKey> fetchAll(String spaceId) {
        this.assertNotNull(spaceId, "spaceId");
        return (CMAArray)((ServiceApiKeys)this.service).fetchAll(spaceId).blockingFirst();
    }

    public CMAArray<CMAApiKey> fetchAll(Map<String, String> query) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId, query);
    }

    public CMAArray<CMAApiKey> fetchAll(String spaceId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        return (CMAArray)((ServiceApiKeys)this.service).fetchAll(spaceId, query).blockingFirst();
    }

    public CMAApiKey fetchOne(String keyId) {
        return this.fetchOne(this.spaceId, keyId);
    }

    public CMAApiKey fetchOne(String spaceId, String keyId) {
        this.assertNotNull(spaceId, "entry");
        this.assertNotNull(keyId, "keyId");
        return (CMAApiKey)((ServiceApiKeys)this.service).fetchOne(spaceId, keyId).blockingFirst();
    }

    public CMAApiKey create(CMAApiKey key) {
        return this.create(this.spaceId, key);
    }

    public CMAApiKey create(String spaceId, CMAApiKey key) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(key, "key");
        return (CMAApiKey)((ServiceApiKeys)this.service).create(spaceId, key).blockingFirst();
    }

    public int delete(CMAApiKey key) {
        this.assertNotNull(key, "key");
        String space = this.getSpaceIdOrThrow(key, "key");
        String id = this.getResourceIdOrThrow(key, "key");
        return ((Response)((ServiceApiKeys)this.service).delete(space, id).blockingFirst()).code();
    }

    public Async async() {
        return this.async;
    }

    public final class Async {
        public CMACallback<CMAArray<CMAApiKey>> fetchAll(CMACallback<CMAArray<CMAApiKey>> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAArray<CMAApiKey>>(){

                @Override
                CMAArray<CMAApiKey> method() {
                    return ModuleApiKeys.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAApiKey>> fetchAll(final String spaceId, CMACallback<CMAArray<CMAApiKey>> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAArray<CMAApiKey>>(){

                @Override
                CMAArray<CMAApiKey> method() {
                    return ModuleApiKeys.this.fetchAll(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAApiKey>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAApiKey>> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAArray<CMAApiKey>>(){

                @Override
                CMAArray<CMAApiKey> method() {
                    return ModuleApiKeys.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAApiKey>> fetchAll(final String spaceId, final Map<String, String> query, CMACallback<CMAArray<CMAApiKey>> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAArray<CMAApiKey>>(){

                @Override
                CMAArray<CMAApiKey> method() {
                    return ModuleApiKeys.this.fetchAll(spaceId, query);
                }
            }, callback);
        }

        public CMACallback<CMAApiKey> fetchOne(final String keyId, CMACallback<CMAApiKey> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAApiKey>(){

                @Override
                CMAApiKey method() {
                    return ModuleApiKeys.this.fetchOne(keyId);
                }
            }, callback);
        }

        public CMACallback<CMAApiKey> fetchOne(final String spaceId, final String keyId, CMACallback<CMAApiKey> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAApiKey>(){

                @Override
                CMAApiKey method() {
                    return ModuleApiKeys.this.fetchOne(spaceId, keyId);
                }
            }, callback);
        }

        public CMACallback<CMAApiKey> create(final CMAApiKey key, CMACallback<CMAApiKey> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAApiKey>(){

                @Override
                CMAApiKey method() {
                    return ModuleApiKeys.this.create(key);
                }
            }, callback);
        }

        public CMACallback<CMAApiKey> create(final String spaceId, final CMAApiKey key, CMACallback<CMAApiKey> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<CMAApiKey>(){

                @Override
                CMAApiKey method() {
                    return ModuleApiKeys.this.create(spaceId, key);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAApiKey key, CMACallback<Integer> callback) {
            return ModuleApiKeys.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleApiKeys.this.delete(key);
                }
            }, callback);
        }
    }
}

