/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.DefaultQueryParameter;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceSpaces;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMASpace;
import com.contentful.java.cma.model.CMASystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ModuleSpaces
extends AbsModule<ServiceSpaces> {
    final Async async = new Async();

    public ModuleSpaces(Retrofit retrofit, Executor callbackExecutor, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, null, null, environmentIdConfigured);
    }

    @Override
    protected ServiceSpaces createService(Retrofit retrofit) {
        return (ServiceSpaces)retrofit.create(ServiceSpaces.class);
    }

    public CMASpace create(String spaceName) {
        this.assertNotNull(spaceName, "spaceName");
        return (CMASpace)((ServiceSpaces)this.service).create(new CMASpace().setName(spaceName).setSystem(null)).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMASpace create(CMASpace space) {
        this.assertNotNull(space, "space");
        CMASystem system = space.getSystem();
        space.setSystem(null);
        try {
            CMASpace cMASpace = (CMASpace)((ServiceSpaces)this.service).create(space).blockingFirst();
            return cMASpace;
        }
        finally {
            space.setSystem(system);
        }
    }

    public CMASpace create(String spaceName, String organizationId) {
        this.assertNotNull(spaceName, "spaceName");
        this.assertNotNull(organizationId, "organizationId");
        return (CMASpace)((ServiceSpaces)this.service).create(organizationId, new CMASpace().setName(spaceName).setSystem(null)).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMASpace create(CMASpace space, String organizationId) {
        this.assertNotNull(space, "space");
        this.assertNotNull(space.getName(), "spaceName");
        this.assertNotNull(organizationId, "organizationId");
        CMASystem system = space.getSystem();
        space.setSystem(null);
        try {
            CMASpace cMASpace = (CMASpace)((ServiceSpaces)this.service).create(organizationId, space).blockingFirst();
            return cMASpace;
        }
        finally {
            space.setSystem(system);
        }
    }

    public Integer delete(String spaceId) {
        this.assertNotNull(spaceId, "spaceId");
        return ((Response)((ServiceSpaces)this.service).delete(spaceId).blockingFirst()).code();
    }

    public Integer delete(CMASpace space) {
        this.assertNotNull(space.getId(), "spaceId");
        return ((Response)((ServiceSpaces)this.service).delete(space.getId()).blockingFirst()).code();
    }

    public CMAArray<CMASpace> fetchAll() {
        return this.fetchAll(new HashMap<String, String>());
    }

    public CMAArray<CMASpace> fetchAll(Map<String, String> query) {
        DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
        return (CMAArray)((ServiceSpaces)this.service).fetchAll(query).blockingFirst();
    }

    public CMASpace fetchOne(String spaceId) {
        this.assertNotNull(spaceId, "spaceId");
        return (CMASpace)((ServiceSpaces)this.service).fetchOne(spaceId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMASpace update(CMASpace space) {
        this.assertNotNull(space, "space");
        this.assertNotNull(space.getName(), "space.name");
        String spaceId = this.getResourceIdOrThrow(space, "space");
        Integer version = this.getVersionOrThrow(space, "update");
        CMASystem system = space.getSystem();
        space.setSystem(null);
        try {
            CMASpace cMASpace = (CMASpace)((ServiceSpaces)this.service).update(version, spaceId, space).blockingFirst();
            return cMASpace;
        }
        finally {
            space.setSystem(system);
        }
    }

    public Async async() {
        return this.async;
    }

    public final class Async {
        public CMACallback<CMASpace> create(final String spaceName, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.create(spaceName);
                }
            }, callback);
        }

        public CMACallback<CMASpace> create(final CMASpace space, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.create(space);
                }
            }, callback);
        }

        public CMACallback<CMASpace> create(final String spaceName, final String organizationId, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.create(spaceName, organizationId);
                }
            }, callback);
        }

        public CMACallback<CMASpace> create(final CMASpace space, final String organizationId, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.create(space, organizationId);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final String spaceId, CMACallback<Integer> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleSpaces.this.delete(spaceId);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMASpace space, CMACallback<Integer> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleSpaces.this.delete(space);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASpace>> fetchAll(CMACallback<CMAArray<CMASpace>> callback) {
            return this.fetchAll(new HashMap<String, String>(), callback);
        }

        public CMACallback<CMAArray<CMASpace>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMASpace>> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMAArray<CMASpace>>(){

                @Override
                CMAArray<CMASpace> method() {
                    DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
                    return ModuleSpaces.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMASpace> fetchOne(final String spaceId, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.fetchOne(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMASpace> update(final CMASpace space, CMACallback<CMASpace> callback) {
            return ModuleSpaces.this.defer(new RxExtensions.DefFunc<CMASpace>(){

                @Override
                CMASpace method() {
                    return ModuleSpaces.this.update(space);
                }
            }, callback);
        }
    }
}

