/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.RateLimits;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;

public class CMAHttpException
extends RuntimeException {
    private final Request request;
    private final Response response;
    private final RateLimits ratelimits;
    private ErrorBody errorBody;

    public CMAHttpException(Request request, Response response) {
        this.request = request;
        this.response = response;
        try {
            String body = response.body() != null ? response.body().string() : null;
            this.errorBody = (ErrorBody)new GsonBuilder().create().fromJson(body, ErrorBody.class);
        }
        catch (IOException e) {
            this.errorBody = null;
        }
        Map headers = response.headers().toMultimap();
        this.ratelimits = new RateLimits.DefaultParser().parse(headers);
    }

    @Override
    public String toString() {
        if (this.errorBody == null) {
            return String.format(Locale.getDefault(), "FAILED \n\t%s\n\t\u21b3 Header{%s}\n\t%s\n\t\u21b3 Header{%s}", this.request.toString(), this.headersToString(this.request.headers()), this.response.toString(), this.headersToString(this.response.headers()));
        }
        return String.format(Locale.getDefault(), "FAILED %s\n\t%s\n\t\u21b3 Header{%s}\n\t%s\n\t\u21b3 Header{%s}", this.errorBody.toString(), this.request.toString(), this.headersToString(this.request.headers()), this.response.toString(), this.headersToString(this.response.headers()));
    }

    public int responseCode() {
        return this.response.code();
    }

    public String responseMessage() {
        return this.response.message();
    }

    public int rateLimitHourLimit() {
        return this.ratelimits.getHourLimit();
    }

    public int rateLimitHourRemaining() {
        return this.ratelimits.getHourRemaining();
    }

    public int rateLimitSecondLimit() {
        return this.ratelimits.getSecondLimit();
    }

    public int rateLimitSecondRemaining() {
        return this.ratelimits.getSecondRemaining();
    }

    public int rateLimitReset() {
        return this.ratelimits.getReset();
    }

    public ErrorBody getErrorBody() {
        return this.errorBody;
    }

    private String headersToString(Headers headers) {
        StringBuilder builder = new StringBuilder();
        String divider = "";
        for (String name : headers.names()) {
            String value = headers.get(name);
            builder.append(divider);
            builder.append(name);
            builder.append(": ");
            builder.append(value);
            if (!"".equals(divider)) continue;
            divider = ", ";
        }
        return builder.toString();
    }

    public static class ErrorBody {
        Sys sys;
        String message;
        String requestId;
        Details details;

        public Sys getSys() {
            return this.sys;
        }

        public String getMessage() {
            return this.message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Details getDetails() {
            return this.details;
        }

        public String toString() {
            return "ErrorBody { " + (this.getDetails() != null ? "details = " + this.getDetails() + ", " : "") + (this.getMessage() != null ? "message = " + this.getMessage() + ", " : "") + (this.getRequestId() != null ? "requestId = " + this.getRequestId() + ", " : "") + (this.getSys() != null ? "sys = " + this.getSys() + " " : "") + "}";
        }

        public static class Details {
            String type;
            String space;
            List<Error> errors;
            List<String> keys;

            public String getType() {
                return this.type;
            }

            public String getSpace() {
                return this.space;
            }

            public List<Error> getErrors() {
                return this.errors;
            }

            public List<String> getKeys() {
                return this.keys;
            }

            public String toString() {
                return "Details { " + (this.getErrors() != null ? "errors = " + this.getErrors() + ", " : "") + (this.getSpace() != null ? "space = " + this.getSpace() + ", " : "") + (this.getKeys() != null ? "keys = " + this.getKeys() + ", " : "") + (this.getType() != null ? "type = " + this.getType() + " " : "") + "}";
            }

            public static class Error {
                String name;
                String details;
                String type;
                String filter;
                Object value;
                Object path;
                List<String> expected;

                public String getName() {
                    return this.name;
                }

                public String getDetails() {
                    return this.details;
                }

                public String getType() {
                    return this.type;
                }

                public String getFilter() {
                    return this.filter;
                }

                public Object getValue() {
                    return this.value;
                }

                public List<String> getExpected() {
                    return this.expected;
                }

                public Object getPath() {
                    return this.path;
                }

                public String toString() {
                    return "Error { " + (this.getDetails() != null ? "details = " + this.getDetails() + ", " : "") + (this.getFilter() != null ? "filter = " + this.getFilter() + ", " : "") + (this.getName() != null ? "name = " + this.getName() + ", " : "") + (this.getPath() != null ? "path = " + this.getPath() + ", " : "") + (this.getType() != null ? "type = " + this.getType() + ", " : "") + (this.getValue() != null ? "value = " + this.getValue() + " " : "") + "}";
                }
            }
        }

        public static class Sys {
            String type;
            String id;

            public String getType() {
                return this.type;
            }

            public String getId() {
                return this.id;
            }

            public String toString() {
                return "Sys { " + (this.getId() != null ? "id = " + this.getId() + ", " : "") + (this.getType() != null ? "type = " + this.getType() + " " : "") + "}";
            }
        }
    }
}

