/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMAConstraint;
import java.util.LinkedList;
import java.util.List;

public class CMAPolicy {
    public static final String ALLOW = "allow";
    public static final String DENY = "deny";
    private String effect;
    private CMAConstraint constraint;
    private Object actions;

    public String getEffect() {
        return this.effect;
    }

    public CMAPolicy setEffect(String effect) {
        this.effect = effect;
        return this;
    }

    public CMAConstraint getConstraint() {
        return this.constraint;
    }

    public CMAPolicy setConstraint(CMAConstraint constraint) {
        this.constraint = constraint;
        return this;
    }

    public Object getActions() {
        return this.actions;
    }

    public CMAPolicy setActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public CMAPolicy allow() {
        return this.setEffect(ALLOW);
    }

    public CMAPolicy deny() {
        return this.setEffect(DENY);
    }

    public CMAPolicy read() {
        return this.addActionSafely("read");
    }

    public CMAPolicy create() {
        return this.addActionSafely("create");
    }

    public CMAPolicy update() {
        return this.addActionSafely("udpate");
    }

    public CMAPolicy delete() {
        return this.addActionSafely("delete");
    }

    public CMAPolicy publish() {
        return this.addActionSafely("publish");
    }

    public CMAPolicy unpublish() {
        return this.addActionSafely("unpublish");
    }

    public CMAPolicy archive() {
        return this.addActionSafely("archive");
    }

    public CMAPolicy unarchive() {
        return this.addActionSafely("unarchive");
    }

    private CMAPolicy addActionSafely(String action) {
        List actionList;
        if ("all".equals(this.actions)) {
            return this;
        }
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        if (this.actions instanceof List && !(actionList = (List)this.actions).contains(action)) {
            actionList.add(action);
        }
        return this;
    }

    public String toString() {
        return "CMAPolicy { actions = " + this.getActions() + ", " + "constraint = " + this.getConstraint() + ", " + "effect = " + this.getEffect() + " " + "}";
    }
}

