/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.Constants;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMAType;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class CMAUiExtension
extends CMAResource {
    private static final int MAXIMUM_BYTE_COUNT = 204800;
    Extension extension;

    public CMAUiExtension() {
        super(CMAType.UiExtension);
    }

    public CMAUiExtension setId(String id) {
        super.setId(id);
        return this;
    }

    public Extension getExtension() {
        if (this.extension == null) {
            this.extension = new Extension();
        }
        return this.extension;
    }

    @Override
    public String toString() {
        return "CMAUiExtension { " + super.toString() + " " + "extension = " + this.getExtension() + " " + "}";
    }

    public static class Extension {
        String name;
        List<FieldType> fieldTypes;
        @SerializedName(value="srcdoc")
        String sourceContent;
        @SerializedName(value="src")
        String sourceUrl;
        @SerializedName(value="sidebar")
        boolean onSidebar;

        public String getName() {
            return this.name;
        }

        public Extension setName(String name) {
            this.name = name;
            return this;
        }

        public List<FieldType> getFieldTypes() {
            return this.fieldTypes;
        }

        public Extension addFieldType(Constants.CMAFieldType type) {
            if (this.fieldTypes == null) {
                this.fieldTypes = new ArrayList<FieldType>();
            }
            this.fieldTypes.add(new FieldType().setType(type));
            return this;
        }

        public String getSourceContent() {
            return this.sourceContent;
        }

        public Extension setSourceContent(String sourceContent) {
            if (sourceContent.getBytes().length >= 204800) {
                throw new IllegalArgumentException("Source content to big. Please provide less then 200kb of source code or use sourceUrl.");
            }
            this.sourceContent = sourceContent;
            return this;
        }

        public String getSourceUrl() {
            return this.sourceUrl;
        }

        public Extension setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public boolean isOnSidebar() {
            return this.onSidebar;
        }

        public Extension setIsOnSidebar(boolean available) {
            this.onSidebar = available;
            return this;
        }

        public String toString() {
            return "Extension { fieldTypes = " + this.getFieldTypes() + ", " + "name = " + this.getName() + ", " + "onSidebar = " + this.isOnSidebar() + ", " + "sourceContent = " + this.getSourceContent() + ", " + "sourceUrl = " + this.getSourceUrl() + " " + "}";
        }

        public static class FieldType {
            Constants.CMAFieldType type;

            public Constants.CMAFieldType getType() {
                return this.type;
            }

            public FieldType setType(Constants.CMAFieldType type) {
                this.type = type;
                return this;
            }

            public String toString() {
                return "FieldType { type = " + (Object)((Object)this.getType()) + " " + "}";
            }
        }
    }
}

