/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;
import com.contentful.java.cma.model.CMAWebhookHeader;
import com.contentful.java.cma.model.CMAWebhookTopic;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class CMAWebhook
extends CMAResource {
    String name;
    String url;
    List<CMAWebhookTopic> topics;
    List<CMAWebhookHeader> headers;
    @SerializedName(value="httpBasicUsername")
    String user;
    @SerializedName(value="httpBasicPassword")
    String password;

    public CMAWebhook() {
        super(CMAType.WebhookDefinition);
    }

    public CMAWebhook setSystem(CMASystem system) {
        this.system = system;
        return this;
    }

    public CMAWebhook setId(String id) {
        return (CMAWebhook)super.setId(id);
    }

    public CMAWebhook setVersion(Integer version) {
        return (CMAWebhook)super.setVersion(version);
    }

    public CMAWebhook setSpaceId(String spaceId) {
        return (CMAWebhook)super.setSpaceId(spaceId);
    }

    public CMAWebhook addTopic(CMAWebhookTopic topic) {
        if (this.topics == null) {
            this.topics = new ArrayList<CMAWebhookTopic>();
        }
        this.topics.add(topic);
        return this;
    }

    public CMAWebhook addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new ArrayList<CMAWebhookHeader>();
        }
        this.headers.add(new CMAWebhookHeader(key, value));
        return this;
    }

    public CMAWebhook setBasicAuthorization(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CMAWebhook setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public CMAWebhook setUrl(String url) {
        this.url = url;
        return this;
    }

    public List<CMAWebhookTopic> getTopics() {
        return new ArrayList<CMAWebhookTopic>(this.topics);
    }

    public List<CMAWebhookHeader> getHeaders() {
        return new ArrayList<CMAWebhookHeader>(this.headers);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String toString() {
        return "CMAWebhook { " + super.toString() + " " + "url = " + this.getUrl() + ", " + "name = " + this.getName() + ", " + "password = " + this.getPassword() + ", " + "user = " + this.getUser() + ", " + (this.topics == null ? "" : "topics = " + this.getTopics() + ", ") + (this.headers == null ? "" : "headers = " + this.getHeaders() + " ") + "}";
    }
}

