/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.model.CMANotWithEnvironmentsException;
import com.contentful.java.cma.model.CMAResource;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import retrofit2.Retrofit;

abstract class AbsModule<T> {
    final T service;
    final Executor callbackExecutor;
    final String spaceId;
    final String environmentId;
    final Boolean environmentIdConfigured;

    AbsModule(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        this.service = this.createService(retrofit);
        this.callbackExecutor = callbackExecutor;
        this.spaceId = spaceId;
        this.environmentId = environmentId;
        this.environmentIdConfigured = environmentIdConfigured;
    }

    protected abstract T createService(Retrofit var1);

    void assertNotNull(Object object, String param) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s may not be null.", param));
        }
    }

    String getResourceIdOrThrow(CMAResource resource, String param) {
        String resourceId = resource.getId();
        if (resourceId == null) {
            throw new IllegalArgumentException(String.format("%s.setId() was not called.", param));
        }
        return resourceId;
    }

    String getSpaceIdOrThrow(CMAResource resource, String param) {
        String spaceId = resource.getSpaceId();
        if (spaceId == null) {
            throw new IllegalArgumentException(String.format("%s must have a space associated.", param));
        }
        return spaceId;
    }

    Integer getVersionOrThrow(CMAResource resource, String action) {
        Integer version = resource.getVersion();
        if (version == null) {
            throw new IllegalArgumentException(String.format("Cannot perform %s action on a resource that has no version associated.", action));
        }
        return version;
    }

    <R> CMACallback<R> defer(RxExtensions.DefFunc<R> func, CMACallback<R> callback) {
        this.assertNotNull(callback, "callback");
        Observable.defer(func).subscribeOn(Schedulers.io()).subscribe(new RxExtensions.ActionSuccess<R>(this.callbackExecutor, callback), (Consumer)new RxExtensions.ActionError(this.callbackExecutor, (CMACallback)callback));
        return callback;
    }

    void throwIfEnvironmentIdIsSet() {
        if (this.environmentIdConfigured.booleanValue()) {
            throw new CMANotWithEnvironmentsException();
        }
    }
}

