/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.DefaultQueryParameter;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceAssets;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAAsset;
import com.contentful.java.cma.model.CMASystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ModuleAssets
extends AbsModule<ServiceAssets> {
    final Async async = new Async();

    public ModuleAssets(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceAssets createService(Retrofit retrofit) {
        return (ServiceAssets)retrofit.create(ServiceAssets.class);
    }

    public CMAAsset archive(CMAAsset asset) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return (CMAAsset)((ServiceAssets)this.service).archive(spaceId, environmentId, assetId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAAsset create(String spaceId, String environmentId, CMAAsset asset) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(asset, "asset");
        String assetId = asset.getId();
        CMASystem sys = asset.getSystem();
        asset.setSystem(null);
        try {
            if (assetId == null) {
                CMAAsset cMAAsset = (CMAAsset)((ServiceAssets)this.service).create(spaceId, environmentId, asset).blockingFirst();
                return cMAAsset;
            }
            CMAAsset cMAAsset = (CMAAsset)((ServiceAssets)this.service).create(spaceId, environmentId, assetId, asset).blockingFirst();
            return cMAAsset;
        }
        finally {
            asset.setSystem(sys);
        }
    }

    public CMAAsset create(CMAAsset asset) {
        return this.create(this.spaceId, this.environmentId, asset);
    }

    public Integer delete(CMAAsset asset) {
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return ((Response)((ServiceAssets)this.service).delete(spaceId, environmentId, assetId).blockingFirst()).code();
    }

    public CMAArray<CMAAsset> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId, new HashMap<String, String>());
    }

    public CMAArray<CMAAsset> fetchAll(Map<String, String> map) {
        return this.fetchAll(this.spaceId, this.environmentId, map);
    }

    public CMAArray<CMAAsset> fetchAll(String spaceId, String environmentId) {
        return this.fetchAll(spaceId, environmentId, new HashMap<String, String>());
    }

    public CMAArray<CMAAsset> fetchAll(String spaceId, String environmentId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
        return (CMAArray)((ServiceAssets)this.service).fetchAll(spaceId, environmentId, query).blockingFirst();
    }

    public CMAAsset fetchOne(String assetId) {
        return this.fetchOne(this.spaceId, this.environmentId, assetId);
    }

    public CMAAsset fetchOne(String spaceId, String environmentId, String assetId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(assetId, "assetId");
        return (CMAAsset)((ServiceAssets)this.service).fetchOne(spaceId, environmentId, assetId).blockingFirst();
    }

    public Integer process(CMAAsset asset, String locale) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return ((Response)((ServiceAssets)this.service).process(spaceId, environmentId, assetId, locale).blockingFirst()).code();
    }

    public CMAAsset publish(CMAAsset asset) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return (CMAAsset)((ServiceAssets)this.service).publish(asset.getSystem().getVersion(), spaceId, environmentId, assetId).blockingFirst();
    }

    public CMAAsset unArchive(CMAAsset asset) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return (CMAAsset)((ServiceAssets)this.service).unArchive(spaceId, environmentId, assetId).blockingFirst();
    }

    public CMAAsset unPublish(CMAAsset asset) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        return (CMAAsset)((ServiceAssets)this.service).unPublish(spaceId, environmentId, assetId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAAsset update(CMAAsset asset) {
        this.assertNotNull(asset, "asset");
        String assetId = this.getResourceIdOrThrow(asset, "asset");
        String spaceId = this.getSpaceIdOrThrow(asset, "asset");
        String environmentId = asset.getEnvironmentId();
        Integer version = this.getVersionOrThrow(asset, "update");
        CMASystem sys = asset.getSystem();
        asset.setSystem(null);
        try {
            CMAAsset cMAAsset = (CMAAsset)((ServiceAssets)this.service).update(version, spaceId, environmentId, assetId, asset).blockingFirst();
            return cMAAsset;
        }
        finally {
            asset.setSystem(sys);
        }
    }

    public Async async() {
        return this.async;
    }

    public final class Async {
        public CMACallback<CMAAsset> archive(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.archive(asset);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> create(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.create(asset);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> create(final String spaceId, final String environmentId, final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.create(spaceId, environmentId, asset);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAAsset asset, CMACallback<Integer> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleAssets.this.delete(asset);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAAsset>> fetchAll(CMACallback<CMAArray<CMAAsset>> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAArray<CMAAsset>>(){

                @Override
                CMAArray<CMAAsset> method() {
                    return ModuleAssets.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAAsset>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAAsset>> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAArray<CMAAsset>>(){

                @Override
                CMAArray<CMAAsset> method() {
                    return ModuleAssets.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAAsset>> fetchAll(final String spaceId, final String environmentId, CMACallback<CMAArray<CMAAsset>> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAArray<CMAAsset>>(){

                @Override
                CMAArray<CMAAsset> method() {
                    return ModuleAssets.this.fetchAll(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAAsset>> fetchAll(final String spaceId, final String environmentId, final Map<String, String> query, CMACallback<CMAArray<CMAAsset>> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAArray<CMAAsset>>(){

                @Override
                CMAArray<CMAAsset> method() {
                    return ModuleAssets.this.fetchAll(spaceId, environmentId, query);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> fetchOne(final String assetId, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.fetchOne(assetId);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> fetchOne(final String spaceId, final String environmentId, final String assetId, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.fetchOne(spaceId, environmentId, assetId);
                }
            }, callback);
        }

        public CMACallback<Integer> process(final CMAAsset asset, final String locale, CMACallback<Integer> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleAssets.this.process(asset, locale);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> publish(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.publish(asset);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> unArchive(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.unArchive(asset);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> unPublish(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.unPublish(asset);
                }
            }, callback);
        }

        public CMACallback<CMAAsset> update(final CMAAsset asset, CMACallback<CMAAsset> callback) {
            return ModuleAssets.this.defer(new RxExtensions.DefFunc<CMAAsset>(){

                @Override
                CMAAsset method() {
                    return ModuleAssets.this.update(asset);
                }
            }, callback);
        }
    }
}

