/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceWebhooks;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAWebhook;
import com.contentful.java.cma.model.CMAWebhookCall;
import com.contentful.java.cma.model.CMAWebhookCallDetail;
import com.contentful.java.cma.model.CMAWebhookHealth;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleWebhooks
extends AbsModule<ServiceWebhooks> {
    final Async async = new Async();

    public ModuleWebhooks(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceWebhooks createService(Retrofit retrofit) {
        return (ServiceWebhooks)retrofit.create(ServiceWebhooks.class);
    }

    public Async async() {
        return this.async;
    }

    public CMAWebhook create(CMAWebhook webhook) {
        this.throwIfEnvironmentIdIsSet();
        return this.create(this.spaceId, webhook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAWebhook create(String spaceId, CMAWebhook webhook) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(webhook, "webhook");
        String webhookId = webhook.getId();
        CMASystem system = webhook.getSystem();
        webhook.setSystem(null);
        try {
            if (webhookId == null) {
                CMAWebhook cMAWebhook = (CMAWebhook)((ServiceWebhooks)this.service).create(spaceId, webhook).blockingFirst();
                return cMAWebhook;
            }
            CMAWebhook cMAWebhook = (CMAWebhook)((ServiceWebhooks)this.service).create(spaceId, webhookId, webhook).blockingFirst();
            return cMAWebhook;
        }
        finally {
            webhook.setSystem(system);
        }
    }

    public Integer delete(CMAWebhook webhook) {
        String webhookId = this.getResourceIdOrThrow(webhook, "webhook");
        String spaceId = this.getSpaceIdOrThrow(webhook, "webhook");
        return ((Response)((ServiceWebhooks)this.service).delete(spaceId, webhookId).blockingFirst()).code();
    }

    public CMAArray<CMAWebhook> fetchAll() {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId);
    }

    public CMAArray<CMAWebhook> fetchAll(Map<String, String> query) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId, query);
    }

    public CMAArray<CMAWebhook> fetchAll(String spaceId) {
        return this.fetchAll(spaceId, null);
    }

    public CMAArray<CMAWebhook> fetchAll(String spaceId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        if (query == null) {
            return (CMAArray)((ServiceWebhooks)this.service).fetchAll(spaceId).blockingFirst();
        }
        return (CMAArray)((ServiceWebhooks)this.service).fetchAll(spaceId, query).blockingFirst();
    }

    public CMAWebhook fetchOne(String webhookId) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchOne(this.spaceId, webhookId);
    }

    public CMAWebhook fetchOne(String spaceId, String webhookId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(webhookId, "webhookId");
        return (CMAWebhook)((ServiceWebhooks)this.service).fetchOne(spaceId, webhookId).blockingFirst();
    }

    public CMAWebhook update(CMAWebhook webhook) {
        this.assertNotNull(webhook, "webhook");
        String webhookId = this.getResourceIdOrThrow(webhook, "webhook");
        String spaceId = this.getSpaceIdOrThrow(webhook, "webhook");
        Integer version = this.getVersionOrThrow(webhook, "webhook");
        return (CMAWebhook)((ServiceWebhooks)this.service).update(version, spaceId, webhookId, webhook).blockingFirst();
    }

    public CMAArray<CMAWebhookCall> calls(CMAWebhook webhook) {
        String spaceId = this.getSpaceIdOrThrow(webhook, "webhook");
        String webhookId = this.getResourceIdOrThrow(webhook, "webhook");
        return (CMAArray)((ServiceWebhooks)this.service).calls(spaceId, webhookId).blockingFirst();
    }

    public CMAWebhookCallDetail callDetails(CMAWebhookCall call) {
        String spaceId = this.getSpaceIdOrThrow(call, "call");
        String callId = this.getResourceIdOrThrow(call, "call");
        this.assertNotNull(call.getSystem().getCreatedBy().getId(), "webhook.sys.createdBy");
        String webhookId = call.getSystem().getCreatedBy().getId();
        return (CMAWebhookCallDetail)((ServiceWebhooks)this.service).callDetails(spaceId, webhookId, callId).blockingFirst();
    }

    public CMAWebhookHealth health(CMAWebhook webhook) {
        String spaceId = this.getSpaceIdOrThrow(webhook, "webhook");
        String webhookId = this.getResourceIdOrThrow(webhook, "webhook");
        return (CMAWebhookHealth)((ServiceWebhooks)this.service).health(spaceId, webhookId).blockingFirst();
    }

    public final class Async {
        public CMACallback<CMAWebhook> create(final CMAWebhook webhook, CMACallback<CMAWebhook> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhook>(){

                @Override
                CMAWebhook method() {
                    return ModuleWebhooks.this.create(webhook);
                }
            }, callback);
        }

        public CMACallback<CMAWebhook> create(final String spaceId, final CMAWebhook webhook, CMACallback<CMAWebhook> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhook>(){

                @Override
                CMAWebhook method() {
                    return ModuleWebhooks.this.create(spaceId, webhook);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAWebhook webhook, CMACallback<Integer> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleWebhooks.this.delete(webhook);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAWebhook>> fetchAll(CMACallback<CMAArray<CMAWebhook>> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAArray<CMAWebhook>>(){

                @Override
                CMAArray<CMAWebhook> method() {
                    return ModuleWebhooks.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAWebhook>> fetchAll(final String spaceId, CMACallback<CMAArray<CMAWebhook>> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAArray<CMAWebhook>>(){

                @Override
                CMAArray<CMAWebhook> method() {
                    return ModuleWebhooks.this.fetchAll(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAWebhook>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAWebhook>> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAArray<CMAWebhook>>(){

                @Override
                CMAArray<CMAWebhook> method() {
                    return ModuleWebhooks.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAWebhook>> fetchAll(final String spaceId, final Map<String, String> query, CMACallback<CMAArray<CMAWebhook>> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAArray<CMAWebhook>>(){

                @Override
                CMAArray<CMAWebhook> method() {
                    return ModuleWebhooks.this.fetchAll(spaceId, query);
                }
            }, callback);
        }

        public CMACallback<CMAWebhook> fetchOne(final String webhookId, CMACallback<CMAWebhook> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhook>(){

                @Override
                CMAWebhook method() {
                    return ModuleWebhooks.this.fetchOne(webhookId);
                }
            }, callback);
        }

        public CMACallback<CMAWebhook> fetchOne(final String spaceId, final String webhookId, CMACallback<CMAWebhook> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhook>(){

                @Override
                CMAWebhook method() {
                    return ModuleWebhooks.this.fetchOne(spaceId, webhookId);
                }
            }, callback);
        }

        public CMACallback<CMAWebhook> update(final CMAWebhook webhook, CMACallback<CMAWebhook> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhook>(){

                @Override
                CMAWebhook method() {
                    return ModuleWebhooks.this.update(webhook);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAWebhookCall>> calls(final CMAWebhook webhook, CMACallback<CMAArray<CMAWebhookCall>> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAArray<CMAWebhookCall>>(){

                @Override
                CMAArray<CMAWebhookCall> method() {
                    return ModuleWebhooks.this.calls(webhook);
                }
            }, callback);
        }

        public CMACallback<CMAWebhookCallDetail> callDetails(final CMAWebhookCall call, CMACallback<CMAWebhookCallDetail> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhookCallDetail>(){

                @Override
                CMAWebhookCallDetail method() {
                    return ModuleWebhooks.this.callDetails(call);
                }
            }, callback);
        }

        public CMACallback<CMAWebhookHealth> health(final CMAWebhook webhook, CMACallback<CMAWebhookHealth> callback) {
            return ModuleWebhooks.this.defer(new RxExtensions.DefFunc<CMAWebhookHealth>(){

                @Override
                CMAWebhookHealth method() {
                    return ModuleWebhooks.this.health(webhook);
                }
            }, callback);
        }
    }
}

