/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import android.os.Handler;
import android.os.Looper;
import com.contentful.java.cma.SynchronousExecutor;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;

public abstract class Platform {
    private static Platform platform = null;

    public static Platform get() {
        if (platform == null) {
            platform = Platform.findPlatform();
        }
        return platform;
    }

    private static Platform findPlatform() {
        if (Platform.tryGettingAndroidSDKNumber() > 0) {
            return new Android();
        }
        return new Base();
    }

    private static String tryGettingAndroidReleaseVersionString() {
        try {
            Class<?> buildsVersionClass = Class.forName("android.os.Build$VERSION");
            Field releaseField = buildsVersionClass.getField("RELEASE");
            return (String)releaseField.get(null);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static int tryGettingAndroidSDKNumber() {
        try {
            Class<?> buildsVersionClass = Class.forName("android.os.Build$VERSION");
            Field versionInt = buildsVersionClass.getField("SDK_INT");
            return (Integer)versionInt.get(null);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    public abstract Executor callbackExecutor();

    public abstract String name();

    public abstract String version();

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        public Executor callbackExecutor() {
            return new Executor(){
                private final Handler handler = new Handler(Looper.getMainLooper());

                @Override
                public void execute(Runnable command) {
                    this.handler.post(command);
                }
            };
        }

        @Override
        public String name() {
            return "Android";
        }

        @Override
        public String version() {
            return Platform.tryGettingAndroidReleaseVersionString();
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        public Executor callbackExecutor() {
            return new SynchronousExecutor();
        }

        @Override
        public String name() {
            return System.getProperty("os.name", "");
        }

        @Override
        public String version() {
            return System.getProperty("os.version", "");
        }
    }
}

