/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAAsset;
import io.reactivex.Flowable;
import java.util.Map;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

interface ServiceAssets {
    @PUT(value="spaces/{space}/environments/{environment}/assets/{asset}/archived")
    public Flowable<CMAAsset> archive(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3);

    @POST(value="spaces/{space}/environments/{environment}/assets")
    public Flowable<CMAAsset> create(@Path(value="space") String var1, @Path(value="environment") String var2, @Body CMAAsset var3);

    @PUT(value="spaces/{space}/environments/{environment}/assets/{asset}")
    public Flowable<CMAAsset> create(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3, @Body CMAAsset var4);

    @DELETE(value="spaces/{space}/environments/{environment}/assets/{asset}")
    public Flowable<Response<Void>> delete(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3);

    @GET(value="spaces/{space}/environments/{environment}/assets")
    public Flowable<CMAArray<CMAAsset>> fetchAll(@Path(value="space") String var1, @Path(value="environment") String var2, @QueryMap Map<String, String> var3);

    @GET(value="spaces/{space}/environments/{environment}/assets/{asset}")
    public Flowable<CMAAsset> fetchOne(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3);

    @PUT(value="spaces/{space}/environments/{environment}/assets/{asset}/files/{locale}/process")
    public Flowable<Response<Void>> process(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3, @Path(value="locale") String var4);

    @PUT(value="spaces/{space}/environments/{environment}/assets/{asset}/published")
    public Flowable<CMAAsset> publish(@Header(value="X-Contentful-Version") Integer var1, @Path(value="space") String var2, @Path(value="environment") String var3, @Path(value="asset") String var4);

    @DELETE(value="spaces/{space}/environments/{environment}/assets/{asset}/archived")
    public Flowable<CMAAsset> unArchive(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3);

    @DELETE(value="spaces/{space}/environments/{environment}/assets/{asset}/published")
    public Flowable<CMAAsset> unPublish(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="asset") String var3);

    @PUT(value="spaces/{space}/environments/{environment}/assets/{asset}")
    public Flowable<CMAAsset> update(@Header(value="X-Contentful-Version") Integer var1, @Path(value="space") String var2, @Path(value="environment") String var3, @Path(value="asset") String var4, @Body CMAAsset var5);
}

