/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.gson;

import com.contentful.java.cma.model.CMAAsset;
import com.contentful.java.cma.model.CMAEntry;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;
import com.contentful.java.cma.model.rich.CMARichBlock;
import com.contentful.java.cma.model.rich.CMARichHyperLink;
import com.contentful.java.cma.model.rich.CMARichNode;
import com.contentful.java.cma.model.rich.RichTextFactory;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntrySerializer
implements JsonSerializer<CMAEntry>,
JsonDeserializer<CMAEntry> {
    private final Gson freshGson = new Gson();

    public JsonElement serialize(CMAEntry src, Type type, JsonSerializationContext context) {
        JsonObject fields = new JsonObject();
        for (Map.Entry<String, LinkedHashMap<String, Object>> field : src.getFields().entrySet()) {
            LinkedHashMap<String, Object> value = field.getValue();
            if (value == null) continue;
            String fieldId = field.getKey();
            JsonObject jsonField = this.serializeField(context, field.getValue());
            if (jsonField == null) continue;
            fields.add(fieldId, (JsonElement)jsonField);
        }
        JsonObject result = new JsonObject();
        result.add("fields", (JsonElement)fields);
        CMASystem sys = src.getSystem();
        if (sys != null) {
            result.add("sys", context.serialize((Object)sys));
        }
        return result;
    }

    public CMAEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        CMAEntry entry = (CMAEntry)new Gson().fromJson(json, CMAEntry.class);
        RichTextFactory.resolveRichTextField(entry);
        return entry;
    }

    private JsonObject serializeField(JsonSerializationContext context, LinkedHashMap<String, Object> values) {
        JsonObject field = new JsonObject();
        for (String locale : values.keySet()) {
            Object localized = values.get(locale);
            if (localized instanceof CMAResource) {
                field.add(locale, (JsonElement)this.toLink(context, (CMAResource)localized));
                continue;
            }
            if (localized instanceof List) {
                field.add(locale, (JsonElement)this.serializeList(context, (List)localized));
                continue;
            }
            if (localized instanceof CMARichNode) {
                field.add(locale, this.serializeRichNode(context, (CMARichNode)localized));
                continue;
            }
            if (localized == null) continue;
            field.add(locale, context.serialize(localized));
        }
        if (field.entrySet().size() > 0) {
            return field;
        }
        return null;
    }

    private JsonArray serializeList(JsonSerializationContext context, List<Object> list) {
        JsonArray array = new JsonArray();
        for (Object item : list) {
            if (item instanceof CMAResource) {
                array.add((JsonElement)this.toLink(context, (CMAResource)item));
                continue;
            }
            array.add(context.serialize(item));
        }
        return array;
    }

    private JsonElement serializeRichNode(JsonSerializationContext context, CMARichNode node) {
        if (node instanceof CMARichHyperLink) {
            return this.serializeRichHyperlink(context, (CMARichHyperLink)node);
        }
        if (node instanceof CMARichBlock) {
            return this.serializeRichBlock(context, (CMARichBlock)node);
        }
        return context.serialize((Object)node);
    }

    private JsonElement serializeRichBlock(JsonSerializationContext context, CMARichBlock block) {
        JsonObject jsonBlock = this.freshGson.toJsonTree((Object)block).getAsJsonObject();
        JsonArray jsonContent = new JsonArray(block.getContent().size());
        for (CMARichNode contentNode : block.getContent()) {
            jsonContent.add(this.serializeRichNode(context, contentNode));
        }
        jsonBlock.add("content", (JsonElement)jsonContent);
        return jsonBlock;
    }

    private JsonElement serializeRichHyperlink(JsonSerializationContext context, CMARichHyperLink link) {
        JsonObject jsonLink = this.freshGson.toJsonTree((Object)link).getAsJsonObject();
        jsonLink.addProperty("nodeType", link.getNodeType());
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(1);
        if (link.getData() instanceof CMAResource) {
            data.put("target", this.toLink(context, (CMAResource)link.getData()));
        } else {
            data.put("uri", link.getData());
            data.remove("target");
        }
        jsonLink.add("data", context.serialize(data));
        return jsonLink;
    }

    private JsonObject toLink(JsonSerializationContext context, CMAResource resource) {
        String id = resource.getId();
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Entry contains link to draft resource (has no ID).");
        }
        CMAType linkedType = resource.getSystem().getLinkType();
        if (linkedType == null) {
            if (resource instanceof CMAAsset) {
                linkedType = CMAType.Asset;
            } else if (resource instanceof CMAEntry) {
                linkedType = CMAType.Entry;
            }
        }
        JsonObject sys = new JsonObject();
        sys.addProperty("type", CMAType.Link.toString());
        sys.addProperty("linkType", linkedType.toString());
        sys.addProperty("id", id);
        JsonObject result = new JsonObject();
        result.add("sys", context.serialize((Object)sys));
        return result;
    }
}

