/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model;

import com.contentful.java.cma.model.CMALink;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;
import com.google.gson.annotations.SerializedName;

public class CMAResource {
    @SerializedName(value="sys")
    CMASystem system = new CMASystem();

    public CMAResource(CMAType type) {
        this.getSystem().setType(type);
    }

    public CMASystem getSystem() {
        return this.system;
    }

    public <T extends CMAResource> T setSystem(CMASystem system) {
        this.system = system;
        return (T)this;
    }

    public String getId() {
        return this.getSystem().getId();
    }

    public <T extends CMAResource> T setId(String id) {
        this.getSystem().setId(id);
        return (T)this;
    }

    public Integer getVersion() {
        return this.getSystem().getVersion();
    }

    public <T extends CMAResource> T setVersion(Integer version) {
        this.getSystem().setVersion(version);
        return (T)this;
    }

    public String getSpaceId() {
        CMALink space = this.getSystem().getSpace();
        if (space != null) {
            return space.getSystem().getId();
        }
        return null;
    }

    public <T extends CMAResource> T setSpaceId(String spaceId) {
        if (this.getSystem().getSpace() == null) {
            this.getSystem().space = new CMALink(CMAType.Space);
        }
        this.getSystem().space.setId(spaceId);
        return (T)this;
    }

    public String getEnvironmentId() {
        CMALink environment = this.getSystem().getEnvironment();
        if (environment != null && environment.getId() != null && !environment.getId().isEmpty()) {
            return environment.getId();
        }
        return "master";
    }

    public <T extends CMAResource> T setEnvironmentId(String environmentId) {
        if (this.getSystem().getEnvironment() == null) {
            this.getSystem().environment = new CMALink(CMAType.Environment);
        }
        this.getSystem().environment.setId(environmentId);
        return (T)this;
    }

    public Boolean isArchived() {
        return this.system != null && this.system.getArchivedVersion() != null;
    }

    public Boolean isPublished() {
        return this.system != null && this.system.getPublishedVersion() != null;
    }

    public String toString() {
        return "CMAResource { system = " + this.getSystem() + " }";
    }
}

