/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.model.rich;

import com.contentful.java.cma.model.CMAEntry;
import com.contentful.java.cma.model.CMALink;
import com.contentful.java.cma.model.CMAType;
import com.contentful.java.cma.model.rich.CMARichBlock;
import com.contentful.java.cma.model.rich.CMARichDocument;
import com.contentful.java.cma.model.rich.CMARichEmbeddedLink;
import com.contentful.java.cma.model.rich.CMARichHeading;
import com.contentful.java.cma.model.rich.CMARichHorizontalRule;
import com.contentful.java.cma.model.rich.CMARichHyperLink;
import com.contentful.java.cma.model.rich.CMARichListItem;
import com.contentful.java.cma.model.rich.CMARichMark;
import com.contentful.java.cma.model.rich.CMARichNode;
import com.contentful.java.cma.model.rich.CMARichOrderedList;
import com.contentful.java.cma.model.rich.CMARichParagraph;
import com.contentful.java.cma.model.rich.CMARichQuote;
import com.contentful.java.cma.model.rich.CMARichText;
import com.contentful.java.cma.model.rich.CMARichUnorderedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class RichTextFactory {
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_3 = 3;
    private static final int LEVEL_4 = 4;
    private static final int LEVEL_5 = 5;
    private static final int LEVEL_6 = 6;
    private static final Map<String, Resolver> RESOLVER_MAP = new HashMap<String, Resolver>();

    public static void resolveRichTextField(CMAEntry entry) {
        if (entry.getFields() != null) {
            for (Map.Entry<String, LinkedHashMap<String, Object>> field : entry.getFields().entrySet()) {
                String fieldId = field.getKey();
                for (String locale : field.getValue().keySet()) {
                    Object value = field.getValue().get(locale);
                    if (!(value instanceof Map) || !((Map)value).containsKey("nodeType")) continue;
                    entry.setField(fieldId, locale, RESOLVER_MAP.get("document").resolve((Map)value));
                }
            }
        }
    }

    static List<CMARichMark> resolveMarks(List<Map<String, Object>> rawMarks) {
        ArrayList<CMARichMark> marks = new ArrayList<CMARichMark>(rawMarks.size());
        for (Map<String, Object> rawMark : rawMarks) {
            String type = (String)rawMark.get("type");
            if ("bold".equals(type)) {
                marks.add(new CMARichMark.CMARichMarkBold());
                continue;
            }
            if ("italic".equals(type)) {
                marks.add(new CMARichMark.CMARichMarkItalic());
                continue;
            }
            if ("underline".equals(type)) {
                marks.add(new CMARichMark.CMARichMarkUnderline());
                continue;
            }
            if ("code".equals(type)) {
                marks.add(new CMARichMark.CMARichMarkCode());
                continue;
            }
            marks.add(new CMARichMark.CMARichMarkCustom(type));
        }
        return marks;
    }

    static CMARichNode resolveRichNode(Map<String, Object> rawNode) {
        String type = (String)rawNode.get("nodeType");
        if (RESOLVER_MAP.containsKey(type)) {
            return RESOLVER_MAP.get(type).resolve(rawNode);
        }
        return null;
    }

    static {
        RESOLVER_MAP.put("text", raw -> new CMARichText((CharSequence)raw.get("value"), RichTextFactory.resolveMarks((List)raw.get("marks"))));
        RESOLVER_MAP.put("hr", raw -> new CMARichHorizontalRule());
        RESOLVER_MAP.put(new CMARichQuote().getNodeType(), new BlockResolver<CMARichQuote>(CMARichQuote::new));
        RESOLVER_MAP.put(new CMARichParagraph().getNodeType(), new BlockResolver<CMARichParagraph>(CMARichParagraph::new));
        RESOLVER_MAP.put(new CMARichDocument().getNodeType(), new BlockResolver<CMARichDocument>(CMARichDocument::new));
        RESOLVER_MAP.put(new CMARichListItem().getNodeType(), new BlockResolver<CMARichListItem>(CMARichListItem::new));
        RESOLVER_MAP.put(new CMARichOrderedList().getNodeType(), new BlockResolver<CMARichOrderedList>(CMARichOrderedList::new));
        RESOLVER_MAP.put(new CMARichUnorderedList().getNodeType(), new BlockResolver<CMARichUnorderedList>(CMARichUnorderedList::new));
        RESOLVER_MAP.put(new CMARichHyperLink().getNodeType(), new BlockAndDataResolver<CMARichHyperLink>(CMARichHyperLink::new, "data"));
        RESOLVER_MAP.put(new CMARichHyperLink(new CMALink(CMAType.Entry)).getNodeType(), new BlockAndDataResolver<CMARichHyperLink>(CMARichHyperLink::new, "data"));
        RESOLVER_MAP.put(new CMARichHyperLink(new CMALink(CMAType.Asset)).getNodeType(), new BlockAndDataResolver<CMARichHyperLink>(CMARichHyperLink::new, "data"));
        RESOLVER_MAP.put(new CMARichEmbeddedLink(new CMALink(CMAType.Entry)).getNodeType(), new BlockAndDataResolver<CMARichEmbeddedLink>(CMARichEmbeddedLink::new, "data"));
        RESOLVER_MAP.put(new CMARichEmbeddedLink(new CMALink(CMAType.Asset)).getNodeType(), new BlockAndDataResolver<CMARichEmbeddedLink>(CMARichEmbeddedLink::new, "data"));
        RESOLVER_MAP.put(new CMARichEmbeddedLink(new CMALink(CMAType.Entry), true).getNodeType(), new BlockAndDataResolver<CMARichEmbeddedLink>(CMARichEmbeddedLink::new, "data"));
        RESOLVER_MAP.put(new CMARichEmbeddedLink(new CMALink(CMAType.Asset), true).getNodeType(), new BlockAndDataResolver<CMARichEmbeddedLink>(CMARichEmbeddedLink::new, "data"));
        RESOLVER_MAP.put(new CMARichHeading(1).getNodeType(), new HeadingResolver(1));
        RESOLVER_MAP.put(new CMARichHeading(2).getNodeType(), new HeadingResolver(2));
        RESOLVER_MAP.put(new CMARichHeading(3).getNodeType(), new HeadingResolver(3));
        RESOLVER_MAP.put(new CMARichHeading(4).getNodeType(), new HeadingResolver(4));
        RESOLVER_MAP.put(new CMARichHeading(5).getNodeType(), new HeadingResolver(5));
        RESOLVER_MAP.put(new CMARichHeading(6).getNodeType(), new HeadingResolver(6));
    }

    private static class BlockAndDataResolver<T extends CMARichBlock>
    extends BlockResolver<T> {
        final SupplierWithData<T> supplier;
        final String dataFieldKey;

        BlockAndDataResolver(SupplierWithData<T> supplier, String dataFieldKey) {
            super(null);
            this.supplier = supplier;
            this.dataFieldKey = dataFieldKey;
        }

        @Override
        T getType(Map<String, Object> raw) {
            Object data = raw.get(this.dataFieldKey);
            if (data instanceof Map && ((Map)data).containsKey("target")) {
                Object target = ((Map)data).get("target");
                if (target instanceof Map) {
                    Map targetMap = (Map)target;
                    Map sys = (Map)targetMap.get("sys");
                    CMALink link = new CMALink();
                    link.getSystem().setId((String)sys.get("id"));
                    link.getSystem().setType(CMAType.Link);
                    link.getSystem().setLinkType(CMAType.valueOf((String)sys.get("linkType")));
                    data = link;
                }
            } else if (data instanceof Map && ((Map)data).containsKey("uri")) {
                data = ((Map)data).get("uri");
            }
            return (T)((CMARichBlock)this.supplier.get(data));
        }
    }

    private static interface SupplierWithData<T> {
        public T get(Object var1);
    }

    private static class HeadingResolver
    extends BlockResolver<CMARichHeading> {
        final int level;

        HeadingResolver(int level) {
            super(() -> new CMARichHeading(level));
            this.level = level;
        }
    }

    private static class BlockResolver<T extends CMARichBlock>
    implements Resolver {
        final Supplier<T> supplier;

        BlockResolver(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public CMARichNode resolve(Map<String, Object> raw) {
            T resolved = this.getType(raw);
            List contents = (List)raw.get("content");
            for (Map rawNode : contents) {
                CMARichNode resolvedNode = RichTextFactory.resolveRichNode(rawNode);
                if (resolvedNode == null) continue;
                ((CMARichBlock)resolved).content.add(resolvedNode);
            }
            return resolved;
        }

        T getType(Map<String, Object> raw) {
            return (T)((CMARichBlock)this.supplier.get());
        }
    }

    private static interface Resolver {
        public CMARichNode resolve(Map<String, Object> var1);
    }
}

