/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.DefaultQueryParameter;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceContentTypes;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAContentType;
import com.contentful.java.cma.model.CMASnapshot;
import com.contentful.java.cma.model.CMASystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleContentTypes
extends AbsModule<ServiceContentTypes> {
    final Async async = new Async();

    public ModuleContentTypes(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceContentTypes createService(Retrofit retrofit) {
        return (ServiceContentTypes)retrofit.create(ServiceContentTypes.class);
    }

    public CMAContentType create(CMAContentType contentType) {
        return this.create(this.spaceId, this.environmentId, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAContentType create(String spaceId, String environmentId, CMAContentType contentType) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(contentType, "contentType");
        this.assertNotNull(environmentId, "environmentId");
        String contentTypeId = contentType.getId();
        CMASystem sys = contentType.getSystem();
        contentType.setSystem(null);
        try {
            if (contentTypeId == null) {
                CMAContentType cMAContentType = (CMAContentType)((ServiceContentTypes)this.service).create(spaceId, environmentId, contentType).blockingFirst();
                return cMAContentType;
            }
            CMAContentType cMAContentType = (CMAContentType)((ServiceContentTypes)this.service).create(spaceId, environmentId, contentTypeId, contentType).blockingFirst();
            return cMAContentType;
        }
        finally {
            contentType.setSystem(sys);
        }
    }

    public Integer delete(CMAContentType contentType) {
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        return ((Response)((ServiceContentTypes)this.service).delete(spaceId, environmentId, contentTypeId).blockingFirst()).code();
    }

    public CMAArray<CMAContentType> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId);
    }

    public CMAArray<CMAContentType> fetchAll(Map<String, String> query) {
        return this.fetchAll(this.spaceId, this.environmentId, query);
    }

    public CMAArray<CMAContentType> fetchAll(String spaceId, String environmentId) {
        return this.fetchAll(spaceId, environmentId, new HashMap<String, String>());
    }

    public CMAArray<CMAContentType> fetchAll(String spaceId, String environmentId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        Map<String, String> enhancedQuery = DefaultQueryParameter.putIfNotSet(query, DefaultQueryParameter.FETCH);
        return (CMAArray)((ServiceContentTypes)this.service).fetchAll(spaceId, environmentId, enhancedQuery).blockingFirst();
    }

    public CMAContentType fetchOne(String contentTypeId) {
        return this.fetchOne(this.spaceId, this.environmentId, contentTypeId);
    }

    public CMAContentType fetchOne(String spaceId, String environmentId, String contentTypeId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(contentTypeId, "contentTypeId");
        return (CMAContentType)((ServiceContentTypes)this.service).fetchOne(spaceId, environmentId, contentTypeId).blockingFirst();
    }

    public CMAContentType publish(CMAContentType contentType) {
        this.assertNotNull(contentType, "contentType");
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        return (CMAContentType)((ServiceContentTypes)this.service).publish(contentType.getVersion(), spaceId, environmentId, contentTypeId).blockingFirst();
    }

    public CMAContentType unPublish(CMAContentType contentType) {
        this.assertNotNull(contentType, "contentType");
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        return (CMAContentType)((ServiceContentTypes)this.service).unPublish(spaceId, environmentId, contentTypeId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAContentType update(CMAContentType contentType) {
        this.assertNotNull(contentType, "contentType");
        this.assertNotNull(contentType.getName(), "contentType.name");
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        Integer version = this.getVersionOrThrow(contentType, "update");
        CMASystem system = contentType.getSystem();
        contentType.setSystem(null);
        try {
            CMAContentType cMAContentType = (CMAContentType)((ServiceContentTypes)this.service).update(version, spaceId, environmentId, contentTypeId, contentType).blockingFirst();
            return cMAContentType;
        }
        finally {
            contentType.setSystem(system);
        }
    }

    public CMAArray<CMASnapshot> fetchAllSnapshots(CMAContentType contentType) {
        this.assertNotNull(contentType, "contentType");
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        return (CMAArray)((ServiceContentTypes)this.service).fetchAllSnapshots(spaceId, environmentId, contentTypeId).blockingFirst();
    }

    public CMASnapshot fetchOneSnapshot(CMAContentType contentType, String snapshotId) {
        this.assertNotNull(contentType, "contentType");
        this.assertNotNull(snapshotId, "snapshotId");
        String contentTypeId = this.getResourceIdOrThrow(contentType, "contentType");
        String spaceId = this.getSpaceIdOrThrow(contentType, "contentType");
        String environmentId = contentType.getEnvironmentId();
        return (CMASnapshot)((ServiceContentTypes)this.service).fetchOneSnapshot(spaceId, environmentId, contentTypeId, snapshotId).blockingFirst();
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAContentType> create(final CMAContentType contentType, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.create(contentType);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> create(final String spaceId, final String environmentId, final CMAContentType contentType, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.create(spaceId, environmentId, contentType);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMAContentType contentType, CMACallback<Integer> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleContentTypes.this.delete(contentType);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAContentType>> fetchAll(CMACallback<CMAArray<CMAContentType>> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAArray<CMAContentType>>(){

                @Override
                CMAArray<CMAContentType> method() {
                    return ModuleContentTypes.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAContentType>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMAContentType>> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAArray<CMAContentType>>(){

                @Override
                CMAArray<CMAContentType> method() {
                    return ModuleContentTypes.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAContentType>> fetchAll(final String spaceId, final String environmentId, CMACallback<CMAArray<CMAContentType>> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAArray<CMAContentType>>(){

                @Override
                CMAArray<CMAContentType> method() {
                    return ModuleContentTypes.this.fetchAll(spaceId, environmentId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMAContentType>> fetchAll(final String spaceId, final String environmentId, final Map<String, String> query, CMACallback<CMAArray<CMAContentType>> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAArray<CMAContentType>>(){

                @Override
                CMAArray<CMAContentType> method() {
                    return ModuleContentTypes.this.fetchAll(spaceId, environmentId, query);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> fetchOne(final String contentTypeId, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.fetchOne(contentTypeId);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> fetchOne(final String spaceId, final String environmentId, final String contentTypeId, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.fetchOne(spaceId, environmentId, contentTypeId);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> publish(final CMAContentType contentType, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.publish(contentType);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> unPublish(final CMAContentType contentType, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.unPublish(contentType);
                }
            }, callback);
        }

        public CMACallback<CMAContentType> update(final CMAContentType contentType, CMACallback<CMAContentType> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAContentType>(){

                @Override
                CMAContentType method() {
                    return ModuleContentTypes.this.update(contentType);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASnapshot>> fetchAllSnapshots(final CMAContentType contentType, CMACallback<CMAArray<CMASnapshot>> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMAArray<CMASnapshot>>(){

                @Override
                CMAArray<CMASnapshot> method() {
                    return ModuleContentTypes.this.fetchAllSnapshots(contentType);
                }
            }, callback);
        }

        public CMACallback<CMASnapshot> fetchOneSnapshot(final CMAContentType contentType, final String snapshotId, CMACallback<CMASnapshot> callback) {
            return ModuleContentTypes.this.defer(new RxExtensions.DefFunc<CMASnapshot>(){

                @Override
                CMASnapshot method() {
                    return ModuleContentTypes.this.fetchOneSnapshot(contentType, snapshotId);
                }
            }, callback);
        }
    }
}

