/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceScheduledActions;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAScheduledAction;
import com.contentful.java.cma.model.CMASystem;
import java.util.concurrent.Executor;
import retrofit2.Retrofit;

public class ModuleScheduledActions
extends AbsModule<ServiceScheduledActions> {
    final Async async = new Async();

    public ModuleScheduledActions(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceScheduledActions createService(Retrofit retrofit) {
        return (ServiceScheduledActions)retrofit.create(ServiceScheduledActions.class);
    }

    public CMAArray<CMAScheduledAction> fetchAll() {
        return this.fetchAll(this.spaceId, this.environmentId);
    }

    public CMAArray<CMAScheduledAction> fetchAll(String spaceId, String environmentId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        return (CMAArray)((ServiceScheduledActions)this.service).fetchAll(spaceId, environmentId).blockingFirst();
    }

    public CMAScheduledAction fetchOne(String scheduledActionId, String entityId) {
        return this.fetchOne(this.spaceId, this.environmentId, scheduledActionId, entityId);
    }

    public CMAScheduledAction fetchOne(String spaceId, String environmentId, String scheduledActionId, String entityId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(environmentId, "environmentId");
        this.assertNotNull(scheduledActionId, "scheduledActionId");
        this.assertNotNull(entityId, "entityId");
        return (CMAScheduledAction)((ServiceScheduledActions)this.service).fetchOne(spaceId, scheduledActionId, entityId, environmentId).blockingFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAScheduledAction create(CMAScheduledAction scheduledAction) {
        this.assertNotNull(scheduledAction, "scheduledAction");
        scheduledAction.setSystem(null);
        CMASystem system = scheduledAction.getSystem();
        scheduledAction.setSystem(null);
        try {
            CMAScheduledAction cMAScheduledAction = (CMAScheduledAction)((ServiceScheduledActions)this.service).create(this.spaceId, scheduledAction).blockingFirst();
            return cMAScheduledAction;
        }
        finally {
            scheduledAction.setSystem(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMAScheduledAction update(String scheduledActionId, CMAScheduledAction scheduledAction) {
        this.assertNotNull(scheduledActionId, "scheduledActionId");
        this.assertNotNull(scheduledAction, "scheduledAction");
        Integer version = this.getVersionOrThrow(scheduledAction, "publish");
        CMASystem system = scheduledAction.getSystem();
        scheduledAction.setSystem(null);
        try {
            CMAScheduledAction cMAScheduledAction = (CMAScheduledAction)((ServiceScheduledActions)this.service).update(version, this.spaceId, scheduledActionId, scheduledAction).blockingFirst();
            return cMAScheduledAction;
        }
        finally {
            scheduledAction.setSystem(system);
        }
    }

    public CMAScheduledAction cancel(String scheduledActionId) {
        this.assertNotNull(scheduledActionId, "scheduledActionId");
        return (CMAScheduledAction)((ServiceScheduledActions)this.service).cancel(this.spaceId, scheduledActionId, this.environmentId).blockingFirst();
    }

    public Async async() {
        return this.async;
    }

    public class Async {
        public CMACallback<CMAArray<CMAScheduledAction>> fetchAll(CMACallback<CMAArray<CMAScheduledAction>> callback) {
            return ModuleScheduledActions.this.defer(new RxExtensions.DefFunc<CMAArray<CMAScheduledAction>>(){

                @Override
                CMAArray<CMAScheduledAction> method() {
                    return ModuleScheduledActions.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAScheduledAction> fetchOne(final String scheduledActionId, final String entityId, CMACallback<CMAScheduledAction> callback) {
            return ModuleScheduledActions.this.defer(new RxExtensions.DefFunc<CMAScheduledAction>(){

                @Override
                CMAScheduledAction method() {
                    return ModuleScheduledActions.this.fetchOne(scheduledActionId, entityId);
                }
            }, callback);
        }

        public CMACallback<CMAScheduledAction> create(final CMAScheduledAction scheduledAction, CMACallback<CMAScheduledAction> callback) {
            return ModuleScheduledActions.this.defer(new RxExtensions.DefFunc<CMAScheduledAction>(){

                @Override
                CMAScheduledAction method() {
                    return ModuleScheduledActions.this.create(scheduledAction);
                }
            }, callback);
        }

        public CMACallback<CMAScheduledAction> update(final String scheduledActionId, final CMAScheduledAction scheduledAction, CMACallback<CMAScheduledAction> callback) {
            return ModuleScheduledActions.this.defer(new RxExtensions.DefFunc<CMAScheduledAction>(){

                @Override
                CMAScheduledAction method() {
                    return ModuleScheduledActions.this.update(scheduledActionId, scheduledAction);
                }
            }, callback);
        }

        public CMACallback<CMAScheduledAction> cancel(final String scheduledActionId, CMACallback<CMAScheduledAction> callback) {
            return ModuleScheduledActions.this.defer(new RxExtensions.DefFunc<CMAScheduledAction>(){

                @Override
                CMAScheduledAction method() {
                    return ModuleScheduledActions.this.cancel(scheduledActionId);
                }
            }, callback);
        }
    }
}

