/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.AbsModule;
import com.contentful.java.cma.CMACallback;
import com.contentful.java.cma.RxExtensions;
import com.contentful.java.cma.ServiceSpaceMemberships;
import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMASpaceMembership;
import com.contentful.java.cma.model.CMASystem;
import java.util.Map;
import java.util.concurrent.Executor;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ModuleSpaceMemberships
extends AbsModule<ServiceSpaceMemberships> {
    private final Async async = new Async();

    public ModuleSpaceMemberships(Retrofit retrofit, Executor callbackExecutor, String spaceId, String environmentId, boolean environmentIdConfigured) {
        super(retrofit, callbackExecutor, spaceId, environmentId, environmentIdConfigured);
    }

    @Override
    protected ServiceSpaceMemberships createService(Retrofit retrofit) {
        return (ServiceSpaceMemberships)retrofit.create(ServiceSpaceMemberships.class);
    }

    public Async async() {
        return this.async;
    }

    public CMAArray<CMASpaceMembership> fetchAll() {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId);
    }

    public CMAArray<CMASpaceMembership> fetchAll(String spaceId) {
        return this.fetchAll(spaceId, null);
    }

    public CMAArray<CMASpaceMembership> fetchAll(Map<String, String> query) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchAll(this.spaceId, query);
    }

    public CMAArray<CMASpaceMembership> fetchAll(String spaceId, Map<String, String> query) {
        this.assertNotNull(spaceId, "spaceId");
        if (query == null) {
            return (CMAArray)((ServiceSpaceMemberships)this.service).fetchAll(spaceId).blockingFirst();
        }
        return (CMAArray)((ServiceSpaceMemberships)this.service).fetchAll(spaceId, query).blockingFirst();
    }

    public CMASpaceMembership fetchOne(String membershipId) {
        this.throwIfEnvironmentIdIsSet();
        return this.fetchOne(this.spaceId, membershipId);
    }

    public CMASpaceMembership fetchOne(String spaceId, String membershipId) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(membershipId, "membershipId");
        return (CMASpaceMembership)((ServiceSpaceMemberships)this.service).fetchOne(spaceId, membershipId).blockingFirst();
    }

    public CMASpaceMembership create(CMASpaceMembership membership) {
        this.throwIfEnvironmentIdIsSet();
        return this.create(this.spaceId, membership);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMASpaceMembership create(String spaceId, CMASpaceMembership membership) {
        this.assertNotNull(spaceId, "spaceId");
        this.assertNotNull(membership, "membership");
        CMASystem sys = membership.getSystem();
        membership.setSystem(null);
        try {
            CMASpaceMembership cMASpaceMembership = (CMASpaceMembership)((ServiceSpaceMemberships)this.service).create(spaceId, membership).blockingFirst();
            return cMASpaceMembership;
        }
        finally {
            membership.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMASpaceMembership update(CMASpaceMembership membership) {
        this.assertNotNull(membership, "membership");
        String id = this.getResourceIdOrThrow(membership, "membership");
        String spaceId = this.getSpaceIdOrThrow(membership, "membership");
        Integer version = this.getVersionOrThrow(membership, "update");
        CMASystem sys = membership.getSystem();
        membership.setSystem(null);
        try {
            CMASpaceMembership cMASpaceMembership = (CMASpaceMembership)((ServiceSpaceMemberships)this.service).update(spaceId, id, membership, version).blockingFirst();
            return cMASpaceMembership;
        }
        finally {
            membership.setSystem(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(CMASpaceMembership membership) {
        String id = this.getResourceIdOrThrow(membership, "membership");
        String spaceId = this.getSpaceIdOrThrow(membership, "membership");
        CMASystem sys = membership.getSystem();
        membership.setSystem(null);
        try {
            Response response = (Response)((ServiceSpaceMemberships)this.service).delete(spaceId, id).blockingFirst();
            int n = response.code();
            return n;
        }
        finally {
            membership.setSystem(sys);
        }
    }

    public class Async {
        public CMACallback<CMAArray<CMASpaceMembership>> fetchAll(CMACallback<CMAArray<CMASpaceMembership>> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMAArray<CMASpaceMembership>>(){

                @Override
                CMAArray<CMASpaceMembership> method() {
                    return ModuleSpaceMemberships.this.fetchAll();
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASpaceMembership>> fetchAll(final String spaceId, CMACallback<CMAArray<CMASpaceMembership>> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMAArray<CMASpaceMembership>>(){

                @Override
                CMAArray<CMASpaceMembership> method() {
                    return ModuleSpaceMemberships.this.fetchAll(spaceId);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASpaceMembership>> fetchAll(final Map<String, String> query, CMACallback<CMAArray<CMASpaceMembership>> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMAArray<CMASpaceMembership>>(){

                @Override
                CMAArray<CMASpaceMembership> method() {
                    return ModuleSpaceMemberships.this.fetchAll(query);
                }
            }, callback);
        }

        public CMACallback<CMAArray<CMASpaceMembership>> fetchAll(final String spaceId, final Map<String, String> query, CMACallback<CMAArray<CMASpaceMembership>> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMAArray<CMASpaceMembership>>(){

                @Override
                CMAArray<CMASpaceMembership> method() {
                    return ModuleSpaceMemberships.this.fetchAll(spaceId, query);
                }
            }, callback);
        }

        public CMACallback<CMASpaceMembership> fetchOne(final String membershipId, CMACallback<CMASpaceMembership> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMASpaceMembership>(){

                @Override
                CMASpaceMembership method() {
                    return ModuleSpaceMemberships.this.fetchOne(membershipId);
                }
            }, callback);
        }

        public CMACallback<CMASpaceMembership> fetchOne(final String spaceId, final String membershipId, CMACallback<CMASpaceMembership> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMASpaceMembership>(){

                @Override
                CMASpaceMembership method() {
                    return ModuleSpaceMemberships.this.fetchOne(spaceId, membershipId);
                }
            }, callback);
        }

        public CMACallback<CMASpaceMembership> create(final String spaceId, final CMASpaceMembership membership, CMACallback<CMASpaceMembership> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMASpaceMembership>(){

                @Override
                CMASpaceMembership method() {
                    return ModuleSpaceMemberships.this.create(spaceId, membership);
                }
            }, callback);
        }

        public CMACallback<CMASpaceMembership> create(final CMASpaceMembership membership, CMACallback<CMASpaceMembership> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMASpaceMembership>(){

                @Override
                CMASpaceMembership method() {
                    return ModuleSpaceMemberships.this.create(membership);
                }
            }, callback);
        }

        public CMACallback<CMASpaceMembership> update(final CMASpaceMembership membership, CMACallback<CMASpaceMembership> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<CMASpaceMembership>(){

                @Override
                CMASpaceMembership method() {
                    return ModuleSpaceMemberships.this.update(membership);
                }
            }, callback);
        }

        public CMACallback<Integer> delete(final CMASpaceMembership membership, CMACallback<Integer> callback) {
            return ModuleSpaceMemberships.this.defer(new RxExtensions.DefFunc<Integer>(){

                @Override
                Integer method() {
                    return ModuleSpaceMemberships.this.delete(membership);
                }
            }, callback);
        }
    }
}

