/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.CMACallback;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class RxExtensions {
    private RxExtensions() {
        throw new UnsupportedOperationException();
    }

    static abstract class DefFunc<T>
    implements Callable<Observable<T>> {
        DefFunc() {
        }

        @Override
        public final Observable<T> call() throws Exception {
            return Observable.just(this.method());
        }

        abstract T method();
    }

    static class ActionError
    extends AbsAction<Throwable> {
        public ActionError(Executor executor, CMACallback callback) {
            super(executor, callback);
        }

        public void accept(Throwable t) throws Exception {
            final RuntimeException exception = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException("Unexpected Exception", t);
            if (!this.callback.isCancelled()) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(exception);
                    }
                });
            }
        }
    }

    static class ActionSuccess<T>
    extends AbsAction<T> {
        public ActionSuccess(Executor executor, CMACallback<T> callback) {
            super(executor, callback);
        }

        public void accept(final T t) throws Exception {
            if (!this.callback.isCancelled()) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess(t);
                    }
                });
            }
        }
    }

    static abstract class AbsAction<T>
    implements Consumer<T> {
        final Executor executor;
        final CMACallback<T> callback;

        public AbsAction(Executor executor, CMACallback<T> callback) {
            this.executor = executor;
            this.callback = callback;
        }
    }
}

