/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma;

import com.contentful.java.cma.model.CMAArray;
import com.contentful.java.cma.model.CMAContentType;
import com.contentful.java.cma.model.CMASnapshot;
import io.reactivex.Flowable;
import java.util.Map;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

interface ServiceContentTypes {
    @POST(value="spaces/{space}/environments/{environment}/content_types")
    public Flowable<CMAContentType> create(@Path(value="space") String var1, @Path(value="environment") String var2, @Body CMAContentType var3);

    @PUT(value="spaces/{space}/environments/{environment}/content_types/{content_type}")
    public Flowable<CMAContentType> create(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="content_type") String var3, @Body CMAContentType var4);

    @DELETE(value="spaces/{space}/environments/{environment}/content_types/{content_type}")
    public Flowable<Response<Void>> delete(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="content_type") String var3);

    @GET(value="spaces/{space}/environments/{environment}/content_types")
    public Flowable<CMAArray<CMAContentType>> fetchAll(@Path(value="space") String var1, @Path(value="environment") String var2, @QueryMap Map<String, String> var3);

    @GET(value="spaces/{space}/environments/{environment}/content_types/{contentTypeId}/snapshots")
    public Flowable<CMAArray<CMASnapshot>> fetchAllSnapshots(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="contentTypeId") String var3);

    @GET(value="spaces/{space}/environments/{environment}/content_types/{content_type}")
    public Flowable<CMAContentType> fetchOne(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="content_type") String var3);

    @GET(value="spaces/{space}/environments/{environment}/content_types/{contentTypeId}/snapshots/{snapshotId}")
    public Flowable<CMASnapshot> fetchOneSnapshot(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="contentTypeId") String var3, @Path(value="snapshotId") String var4);

    @PUT(value="spaces/{space}/environments/{environment}/content_types/{content_type}/published")
    public Flowable<CMAContentType> publish(@Header(value="X-Contentful-Version") Integer var1, @Path(value="space") String var2, @Path(value="environment") String var3, @Path(value="content_type") String var4);

    @DELETE(value="spaces/{space}/environments/{environment}/content_types/{content_type}/published")
    public Flowable<CMAContentType> unPublish(@Path(value="space") String var1, @Path(value="environment") String var2, @Path(value="content_type") String var3);

    @PUT(value="spaces/{space}/environments/{environment}/content_types/{content_type}")
    public Flowable<CMAContentType> update(@Header(value="X-Contentful-Version") Integer var1, @Path(value="space") String var2, @Path(value="environment") String var3, @Path(value="content_type") String var4, @Body CMAContentType var5);
}

