/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.gson;

import com.contentful.java.cma.model.CMAField;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class FieldTypeAdapter
implements JsonSerializer<CMAField> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_LINK_TYPE = "linkType";
    private static final String ATTR_REQUIRED = "required";
    private static final String ATTR_DISABLED = "disabled";
    private static final String ATTR_OMITTED = "omitted";
    private static final String ATTR_LOCALIZED = "localized";
    private static final String ATTR_VALIDATIONS = "validations";
    private static final String ATTR_ARRAY_ITEMS = "items";
    private static final String ATTR_DEFAULT_VALUE = "defaultValue";

    private static <T> void add(JsonObject json, String property, T value) {
        if (value != null) {
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    json.addProperty(property, Boolean.valueOf(true));
                }
            } else if (value instanceof String) {
                json.addProperty(property, (String)value);
            } else {
                json.addProperty(property, value.toString());
            }
        }
    }

    public JsonElement serialize(CMAField field, Type type, JsonSerializationContext context) {
        Map<String, Object> arrayItems;
        Map<String, Object> defaultValue;
        JsonObject json = new JsonObject();
        FieldTypeAdapter.add(json, ATTR_ID, field.getId());
        FieldTypeAdapter.add(json, ATTR_NAME, field.getName());
        FieldTypeAdapter.add(json, ATTR_TYPE, field.getType());
        FieldTypeAdapter.add(json, ATTR_LINK_TYPE, field.getLinkType());
        FieldTypeAdapter.add(json, ATTR_REQUIRED, field.isRequired());
        FieldTypeAdapter.add(json, ATTR_DISABLED, field.isDisabled());
        FieldTypeAdapter.add(json, ATTR_OMITTED, field.isOmitted());
        FieldTypeAdapter.add(json, ATTR_LOCALIZED, field.isLocalized());
        List<Map<String, Object>> validations = field.getValidations();
        if (validations != null) {
            json.add(ATTR_VALIDATIONS, context.serialize(validations, new TypeToken<List<Map<String, Object>>>(){}.getType()));
        }
        if ((defaultValue = field.getDefaultValue()) != null) {
            json.add(ATTR_DEFAULT_VALUE, context.serialize(defaultValue, Map.class));
        }
        if ((arrayItems = field.getArrayItems()) != null) {
            json.add(ATTR_ARRAY_ITEMS, context.serialize(arrayItems, Map.class));
        }
        return json;
    }
}

