/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.java.cma.gson;

import com.contentful.java.cma.model.CMAContentType;
import com.contentful.java.cma.model.CMAEntry;
import com.contentful.java.cma.model.CMAResource;
import com.contentful.java.cma.model.CMASnapshot;
import com.contentful.java.cma.model.CMASystem;
import com.contentful.java.cma.model.CMAType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class SnapshotDeserializer
implements JsonDeserializer<CMASnapshot> {
    public CMASnapshot deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        CMASnapshot result = new CMASnapshot();
        JsonObject jsonObject = json.getAsJsonObject();
        CMASystem system = (CMASystem)context.deserialize(jsonObject.get("sys"), CMASystem.class);
        result.setSystem(system);
        JsonObject snapshot = jsonObject.getAsJsonObject("snapshot");
        String type = snapshot.getAsJsonObject("sys").getAsJsonPrimitive("type").getAsString();
        if (CMAType.ContentType.name().equals(type)) {
            result.setSnapshot((CMAResource)context.deserialize((JsonElement)snapshot, CMAContentType.class));
        } else if (CMAType.Entry.name().equals(type)) {
            result.setSnapshot((CMAResource)context.deserialize((JsonElement)snapshot, CMAEntry.class));
        }
        return result;
    }
}

